UNIT Unit9_data_structures;
INTERFACE
USES SysUtils;

TYPE
  Tstructure_entry=RECORD
      name:String;
      offset:LongWord;
      datatype:Byte;  // 1..4: Integer[1..4] dec; 5..8: Integer[1..4] hex; 9: float; 10: bitset; 11+: string[1+]
      description:String;
    END;
  Tstructure_info=RECORD
      extension:String;
      typedesc:String;
      entries:Array OF Tstructure_entry;
    END;
  Tstructures=Array OF Tstructure_info;

VAR
  structure_infos:Tstructures;


FUNCTION GetDataType(typeid:Byte):String;
FUNCTION GetStructureInfoId(ext:String):Integer;



IMPLEMENTATION

FUNCTION GetStructureInfoId(ext:String):Integer;
  VAR
    i:Integer;
  BEGIN
    FOR i:=0 TO High(structure_infos) DO BEGIN
      IF structure_infos[i].extension=ext THEN BEGIN
        Result:=i;
        Exit;
      END;
    END;
    Result:=-1;
  END;

FUNCTION GetDataType(typeid:Byte):String;
  BEGIN
    CASE typeid OF
      1..4: Result:='Int'+IntToStr(typeid*8);
      5..8: Result:='Int'+IntToStr((typeid-4)*8);
      9: Result:='Float';
      10: Result:='BitSet';
      11..255: Result:='String('+IntToStr(typeid-10)+')';
    END;
  END;

PROCEDURE AddEntry(_ext:String; _name:String; _offset:LongWord; _datatype:Byte; _description:String);
  VAR
    sid:Word;
  BEGIN
    sid:=GetStructureInfoId(_ext);
    IF sid>=0 THEN BEGIN
      WITH structure_infos[sid] DO BEGIN
        SetLength(entries,Length(entries)+1);
        WITH entries[High(entries)] DO BEGIN
          name:=_name;
          offset:=_offset;
          datatype:=_datatype;
          description:=_description;
        END;
      END;
    END;
  END;

PROCEDURE AddExtension(_ext:String; _typedesc:String);
  BEGIN
    IF GetStructureInfoId(_ext)<0 THEN BEGIN
      SetLength(structure_infos,Length(structure_infos)+1);
      WITH structure_infos[High(structure_infos)] DO BEGIN
        extension:='TXMP';
        typedesc:='Texture';
      END;
    END;
  END;

BEGIN
  AddExtension('TXMP','Texture');
  AddEntry('TXMP','Fading',$88,10,'Fading-Bitset');
  AddEntry('TXMP','Depth',$89,10,'Depth-Bitset');
  AddEntry('TXMP','Width',$8C,2,'x-resolution of image');
  AddEntry('TXMP','Height',$8E,2,'y-resolution of image');
  AddEntry('TXMP','Storetype',$90,10,'Storetype-Bitset');
  AddEntry('TXMP','Raw-Link',$9C,8,'Address of the image data in the .raw-file');
END.
