UNIT Unit11_extractor;
INTERFACE
USES
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, StrUtils, ComCtrls;
TYPE
  TForm11 = Class(TForm)
    group_select: TGroupBox;
    panel_extension: TPanel;
    combo_extension: TComboBox;
    list: TListBox;
    group_extract: TGroupBox;
    group_singlefiles: TGroupBox;
    btn_sel_dat: TButton;
    btn_sel_datraw: TButton;
    btn_sel_datraw_convert: TButton;
    btn_all_dat: TButton;
    btn_all_datraw: TButton;
    btn_all_datraw_convert: TButton;
    group_onefile: TGroupBox;
    btn_sel_files_toone: TButton;
    btn_all_files_toone: TButton;
    group_progress: TGroupBox;
    progress: TProgressBar;
    lbl_progress: TLabel;
    lbl_estimated: TLabel;
    btn_abort: TButton;
    saved: TSaveDialog;
    PROCEDURE FormCreate(Sender: TObject);
    PROCEDURE FormActivate(Sender: TObject);
    PROCEDURE FormClose(Sender: TObject; var Action: TCloseAction);
    PROCEDURE FormResize(Sender: TObject);
    PROCEDURE combo_extensionClick(Sender: TObject);
    PROCEDURE panel_extensionResize(Sender: TObject);
    PROCEDURE Extract(Sender: TObject);
  PRIVATE
  PUBLIC
    PROCEDURE Recreatelist;
  END;

VAR
  Form11: TForm11;

IMPLEMENTATION
{$R *.dfm}
USES Unit1_main, Unit2_functions, Unit3_data;

PROCEDURE TForm11.Recreatelist;
  VAR
    i:LongWord;
    exts:TStringList;
  BEGIN
    combo_extension.Items.Clear;
    combo_extension.Items.Add('_All files_ ('{+IntToStr(dat_header.Files)}+')');
    exts:=GetExtensionsList;
    FOR i:=0 TO High(exts) DO
      combo_extension.Items.Add(exts[i]);
    combo_extension.ItemIndex:=0;
    combo_extensionClick(Self);
  END;

PROCEDURE TForm11.panel_extensionResize(Sender: TObject);
  BEGIN
    combo_extension.Width:=panel_extension.Width-5;
  END;

PROCEDURE TForm11.combo_extensionClick(Sender: TObject);
  VAR
    Extension:String[4];
    files:TStringList;
    i:LongWord;
  BEGIN
    Extension:=MidStr(combo_extension.Items.Strings[combo_extension.ItemIndex],1,4);
    list.Items.Clear;
    IF Extension='_All' THEN
      files:=GetFilesList('','',True)
    ELSE
      files:=GetFilesList(extension,'',True);
    IF Length(files)>0 THEN
      FOR i:=0 TO High(files) DO
        list.Items.Add(files[i]);
  END;

PROCEDURE TForm11.FormResize(Sender: TObject);
  BEGIN
    IF Self.Width>=450 THEN BEGIN
    END ELSE Self.Width:=450;
    IF Self.Height>=400 THEN BEGIN
      group_progress.Height:=group_extract.Height-293;
    END ELSE Self.Height:=400;
  END;

PROCEDURE TForm11.FormClose(Sender: TObject; var Action: TCloseAction);
  BEGIN
    Action:=caFree;
    Form1.close_window(Self.Name);
  END;

PROCEDURE TForm11.FormActivate(Sender: TObject);
  BEGIN
    Form1.SetActiveWindow(Self.Name);
  END;

PROCEDURE TForm11.FormCreate(Sender: TObject);
  BEGIN
    btn_sel_dat.Caption:=           'Selected files'+CrLf+'(dat contents only)';
    btn_sel_datraw.Caption:=        'Selected files'+CrLf+'(dat+raw contents)';
    btn_sel_datraw_convert.Caption:='Selected files'+CrLf+'(dat+raw contents)'+CrLf+'(with convert if possible)';
    btn_all_dat.Caption:=           'All files in list'+CrLf+'(dat contents only)';
    btn_all_datraw.Caption:=        'All files in list'+CrLf+'(dat+raw contents)';
    btn_all_datraw_convert.Caption:='All files in list'+CrLf+'(dat+raw contents)'+CrLf+'(with convert if possible)';
    btn_sel_files_toone.Caption:=   'Selected files'+CrLf+'(dat contents only)';
    btn_all_files_toone.Caption:=   'All files in list'+CrLf+'(dat contents only)';
  END;

PROCEDURE TForm11.Extract(Sender: TObject);
  VAR
    sel_only:Boolean;
    dat_only:Boolean;
    convert:Boolean;
    one_file:Boolean;
    settings:TExportSet;
    files:LongWord;
    i,done:LongWord;
    begintime:Double;
  BEGIN
    sel_only:=Pos('sel',TButton(Sender).Name)>0;
    dat_only:=NOT (Pos('datraw',TButton(Sender).Name)>0);
    convert:=Pos('convert',TButton(Sender).Name)>0;
    one_file:=Pos('toone',TButton(Sender).Name)>0;
    IF dat_only THEN settings:=[DO_dat]
    ELSE settings:=[DO_dat,DO_raw];
    IF convert THEN settings:=settings+[DO_convert];
    IF one_file THEN settings:=settings+[DO_toone];
    progress.Position:=0;

    IF saved.Execute THEN BEGIN
      begintime:=Time;
      group_progress.Visible:=True;
      group_select.Enabled:=False;
      group_singlefiles.Enabled:=False;
      group_onefile.Enabled:=False;
      lbl_estimated.Caption:='Estimated finishing time: unknown';
      IF one_file THEN BEGIN
        IF FileExists(saved.FileName) THEN BEGIN
          IF MessageBox(Self.Handle,PChar('File already exists. Do you want to overwrite it?'),PChar('Warning!'),MB_YESNO)=ID_YES THEN BEGIN
            DeleteFile(saved.FileName);
          END ELSE BEGIN
            group_progress.Visible:=False;
            group_select.Enabled:=True;
            group_singlefiles.Enabled:=True;
            group_onefile.Enabled:=True;
            Exit;
          END;
        END;
        i:=FileCreate(saved.FileName);
        FileClose(i);
        i:=0;
      END;
      IF sel_only THEN BEGIN
        files:=list.SelCount;
        lbl_progress.Caption:='Files done: 0/'+IntToStr(files);
        progress.Max:=files;
        done:=0;
        FOR i:=0 TO list.Count-1 DO BEGIN
          IF list.Selected[i] THEN BEGIN
            IF one_file THEN BEGIN
              ExportFile(StrToInt(MidStr(list.Items.Strings[i],1,5)),ExtractFileName(saved.FileName),settings,ExtractFileDir(saved.FileName));
            END ELSE BEGIN
              ExportFile(StrToInt(MidStr(list.Items.Strings[i],1,5)),list.Items.Strings[i],settings,'D:');
            END;
            Inc(done);
          END;
          IF ((done MOD 10)=0) AND (done>=50) THEN
            lbl_estimated.Caption:='Estimated finishing time: '+TimeToStr((Time-begintime)/done*files+begintime);
          IF (i MOD 10)=0 THEN BEGIN
            progress.Position:=done;
            lbl_progress.Caption:='Files done: '+IntToStr(done)+'/'+IntToStr(files);
            Application.ProcessMessages;
          END;
        END;
      END ELSE BEGIN
        files:=list.Count;
        lbl_progress.Caption:='Files done: 0/'+IntToStr(files);
        progress.Max:=files;
        FOR i:=0 TO list.Count-1 DO BEGIN
          IF one_file THEN BEGIN
            ExportFile(StrToInt(MidStr(list.Items.Strings[i],1,5)),ExtractFileName(saved.FileName),settings,ExtractFileDir(saved.FileName));
          END ELSE BEGIN
            ExportFile(StrToInt(MidStr(list.Items.Strings[i],1,5)),list.Items.Strings[i],settings,'D:');
          END;
          IF ((i MOD 10)=0) AND (i>=50) THEN
            lbl_estimated.Caption:='Estimated finishing time: '+TimeToStr((Time-begintime)/i*files+begintime);
          IF (i MOD 5)=0 THEN BEGIN
            progress.Position:=i;
            lbl_progress.Caption:='Files done: '+IntToStr(i)+'/'+IntToStr(files);
            Application.ProcessMessages;
          END;
        END;
      END;
      group_progress.Visible:=False;
      group_select.Enabled:=True;
      group_singlefiles.Enabled:=True;
      group_onefile.Enabled:=True;
    END;
  END;

END.
