UNIT Unit8_binedit;
INTERFACE
USES
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Wrapgrid, StdCtrls, Grids, StrUtils, MPHexEditor, ExtCtrls, Clipbrd,
  Unit3_data, Unit2_functions, Unit9_data_structures, Unit4_exporters, Menus, Math;

TYPE
  TForm8 = Class(TForm)
    Splitter1: TSplitter;
    panel_data: TPanel;
    hex: TMPHexEditor;
    Splitter2: TSplitter;
    structs: TWrapGrid;
    panel_files: TPanel;
    list: TListBox;
    panel_extension: TPanel;
    lbl_filter: TLabel;
    combo_extension: TComboBox;
    Bevel1: TBevel;
    panel_imexport: TPanel;
    btn_export: TButton;
    btn_import: TButton;
    opend: TOpenDialog;
    saved: TSaveDialog;
    value_viewer: TWrapGrid;
    Splitter3: TSplitter;
    value_viewer_context: TPopupMenu;
    value_viewer_context_copy: TMenuItem;
    value_viewer_context_copyashex: TMenuItem;
    value_viewer_context_copyasdec: TMenuItem;
    value_viewer_context_copyasfloat: TMenuItem;
    value_viewer_context_copyasbitset: TMenuItem;
    value_viewer_context_copyasstring: TMenuItem;
    check_zerobyte: TCheckBox;
    edit_filtername: TEdit;
    check_filtername: TCheckBox;
    PROCEDURE LoadFileNames;
    PROCEDURE check_filternameClick(Sender: TObject);
    PROCEDURE check_zerobyteClick(Sender: TObject);
    PROCEDURE combo_extensionClick(Sender: TObject);
    PROCEDURE panel_extensionResize(Sender: TObject);
    PROCEDURE listClick(Sender: TObject);
    PROCEDURE Recreatelist;

    PROCEDURE FormKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
    PROCEDURE value_viewerDblClick(Sender: TObject);
    PROCEDURE structsDblClick(Sender: TObject);
    PROCEDURE value_viewer_context_copyClick(Sender: TObject);
    PROCEDURE value_viewerMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    PROCEDURE value_viewer_contextPopup(Sender: TObject);
    PROCEDURE FormActivate(Sender: TObject);
    PROCEDURE btn_importClick(Sender: TObject);
    PROCEDURE btn_exportClick(Sender: TObject);
    PROCEDURE panel_imexportResize(Sender: TObject);
    FUNCTION Save:Boolean;
    PROCEDURE FormClose(Sender: TObject; var Action: TCloseAction);
    FUNCTION GetValue(datatype:Word; offset:LongWord):String;
    PROCEDURE WriteStructureInfos(structinfoid:Integer);
    PROCEDURE hexSelectionChanged(Sender: TObject);
    PROCEDURE hexChange(Sender: TObject);
    PROCEDURE panel_dataResize(Sender: TObject);
    PROCEDURE structsClick(Sender: TObject);
    PROCEDURE FormResize(Sender: TObject);
    PROCEDURE ClearStructViewer;
    PROCEDURE FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    PROCEDURE FormCreate(Sender: TObject);
    PROCEDURE ClearValues;
    PROCEDURE WriteValues;
    PROCEDURE SetNewValue(datatype:Word; offset:LongWord; value:String);
  PRIVATE
  PUBLIC
  END;

VAR
  Form8: TForm8;

IMPLEMENTATION
{$R *.dfm}
USES Unit1_main, Unit12_ValueEdit, Unit13_rawedit;
VAR
  fileid:LongWord;



PROCEDURE TForm8.Recreatelist;
  VAR
    i:LongWord;
    exts:TStringList;
  BEGIN
    combo_extension.Items.Clear;
    combo_extension.Items.Add('_All files_ ('{+IntToStr(dat_header.Files)}+')');
    exts:=GetExtensionsList;
    FOR i:=0 TO High(exts) DO
      combo_extension.Items.Add(exts[i]);
    combo_extension.ItemIndex:=0;
    combo_extensionClick(Self);
  END;

PROCEDURE TForm8.LoadFileNames;
  VAR
    Extension:String[4];
    no_zero_bytes:Boolean;
    pattern:String;
    files:TStringList;
    i:LongWord;
  BEGIN
    Extension:=MidStr(combo_extension.Items.Strings[combo_extension.ItemIndex],1,4);
    no_zero_bytes:=NOT check_zerobyte.Checked;
    pattern:='';
    IF check_filtername.Checked THEN pattern:=edit_filtername.Text;
    IF Extension='_All' THEN Extension:='';

    files:=GetFilesList(extension,pattern,no_zero_bytes);
    list.Items.Clear;
    IF Length(files)>0 THEN
      FOR i:=0 TO High(files) DO
        list.Items.Add(files[i]);
  END;

PROCEDURE TForm8.panel_extensionResize(Sender: TObject);
  BEGIN
    combo_extension.Width:=panel_extension.Width-5;
    edit_filtername.Width:=panel_extension.Width-5;
  END;

PROCEDURE TForm8.combo_extensionClick(Sender: TObject);
  BEGIN
    LoadFileNames;
  END;

PROCEDURE TForm8.check_zerobyteClick(Sender: TObject);
  VAR
    i:Byte;
  BEGIN
    LoadFileNames;
  END;

PROCEDURE TForm8.check_filternameClick(Sender: TObject);
  BEGIN
    edit_filtername.Enabled:=NOT check_filtername.Checked;
    LoadFileNames;
  END;

PROCEDURE TForm8.listClick(Sender: TObject);
  VAR
    mem:TMemoryStream;
    data:Tdata;
    i:LongWord;
  BEGIN
    IF hex.Modified THEN BEGIN
      IF NOT Save THEN BEGIN
        FOR i:=0 TO list.Count-1 DO BEGIN
          IF StrToInt(MidStr(list.Items.Strings[i],1,5))=fileid THEN BEGIN
            list.ItemIndex:=i;
            Exit;
          END;
        END;
      END;
    END;
    Self.ClearStructViewer;
    fileid:=StrToInt(MidStr(list.Items.Strings[list.ItemIndex],1,5));
    data:=LoadDatFile(fileid);
    IF Length(data)>0 THEN BEGIN
      mem:=TMemoryStream.Create;
      mem.Write(data[0],Length(data));
      mem.Seek(0,soFromBeginning);
      hex.LoadFromStream(mem);
      mem.Free;
      WriteStructureInfos(GetStructureInfoId(GetFileInfo(fileid).Extension));
      structs.Height:=structs.RowCount*20;
      IF structs.Height>120 THEN structs.Height:=120;
    END ELSE BEGIN
      ClearValues;
      hex.DataSize:=0;
    END;
  END;




FUNCTION IntToBin(value:Byte):String;
  VAR i:Byte;
  BEGIN
    Result:='';
    FOR i:=7 DOWNTO 0 DO BEGIN
      Result:=Result+IntToStr((value SHR i) AND $01);
    END;
  END;

FUNCTION TForm8.GetValue(datatype:Word; offset:LongWord):String;
  VAR
    data:Tdata;
    i:Word;
  BEGIN
    CASE datatype OF
      1: Result:=IntToStr(hex.data[offset]);
      2: Result:=IntToStr(hex.data[offset]+hex.data[offset+1]*256);
      3: Result:=IntToStr(hex.data[offset]+hex.data[offset+1]*256+hex.data[offset+2]*256*256);
      4: Result:=IntToStr(hex.data[offset]+hex.data[offset+1]*256+hex.data[offset+2]*256*256+hex.data[offset+3]*256*256*256);
      5: Result:='0x'+IntToHex(hex.data[offset],2);
      6: Result:='0x'+IntToHex(hex.data[offset]+hex.data[offset+1]*256,4);
      7: Result:='0x'+IntToHex(hex.data[offset]+hex.data[offset+1]*256+hex.data[offset+2]*256*256,6);
      8: Result:='0x'+IntToHex(hex.data[offset]+hex.data[offset+1]*256+hex.data[offset+2]*256*256+hex.data[offset+3]*256*256*256,8);
      9: BEGIN
          SetLength(data,4);
          data[0]:=hex.data[offset];
          data[1]:=hex.data[offset+1];
          data[2]:=hex.data[offset+2];
          data[3]:=hex.data[offset+3];
          Result:=FloatToStr(Decode_Float(data));
        END;
      10: Result:=IntToBin(hex.data[offset]);
      11: Result:='0x'+IntToHex(GetRawInfo(fileid,offset).raw_addr,8);
      10000..65535: BEGIN
          Result:='';
          FOR i:=1 TO datatype-10000 DO BEGIN
            IF hex.Data[offset+i-1]>=32 THEN
              Result:=Result+Chr(hex.Data[offset+i-1])
            ELSE
              Result:=Result+'.';
          END;
        END;
    END;
  END;

PROCEDURE TForm8.WriteStructureInfos(structinfoid:Integer);
  VAR
    i:Byte;
  BEGIN
    IF structinfoid>=0 THEN BEGIN
      structs.Enabled:=True;
      WITH structure_infos[structinfoid] DO BEGIN
        Self.structs.RowCount:=Length(entries)+1;
        FOR i:=1 TO Length(entries) DO BEGIN
          Self.structs.Cells[0,i]:=entries[i-1].name;
          Self.structs.Cells[1,i]:='0x'+IntToHex(entries[i-1].offset,6);
          Self.structs.Cells[2,i]:=GetDataType(entries[i-1].datatype);
          IF entries[i-1].datatype>10000 THEN
            Self.structs.Cells[3,i]:='*String*#HINT:'+GetValue(entries[i-1].datatype,entries[i-1].offset)+'#'
          ELSE
            Self.structs.Cells[3,i]:=GetValue(entries[i-1].datatype,entries[i-1].offset);
          Self.structs.Cells[4,i]:=entries[i-1].description;
        END;
      END;
    END;
  END;

PROCEDURE TForm8.ClearValues;
  VAR
    i:Byte;
  BEGIN
    FOR i:=1 TO value_viewer.RowCount-1 DO BEGIN
      value_viewer.Cells[1,i]:='';
    END;
  END;

PROCEDURE TForm8.WriteValues;
  VAR
    i,j:Byte;
    data:Tdata;
    str:String;
    value:LongWord;
  BEGIN
    FOR i:=1 TO value_viewer.RowCount-1 DO BEGIN
      IF value_viewer.Cells[0,i]='1 byte, unsigned' THEN BEGIN
        IF ((hex.SelCount=1) OR (hex.SelCount=0)) AND NOT ((hex.SelStart+1)>hex.DataSize) THEN BEGIN
          value:=hex.Data[hex.SelStart];
          value_viewer.Cells[1,i]:=IntToStr( value )+' / 0x'+IntToHex( value , 2 );
        END ELSE
          value_viewer.Cells[1,i]:='';
      END;
      IF value_viewer.Cells[0,i]='2 bytes, unsigned' THEN BEGIN
        IF ((hex.SelCount=2) OR (hex.SelCount=0)) AND NOT ((hex.SelStart+2)>hex.DataSize) THEN BEGIN
          value:=hex.Data[hex.SelStart] + hex.Data[hex.SelStart+1]*256;
          value_viewer.Cells[1,i]:=IntToStr( value )+' / 0x'+IntToHex( value , 4 );
        END ELSE
          value_viewer.Cells[1,i]:='';
      END;
      IF value_viewer.Cells[0,i]='4 bytes, unsigned' THEN BEGIN
        IF ((hex.SelCount=4) OR (hex.SelCount=0)) AND NOT ((hex.SelStart+4)>hex.DataSize) THEN BEGIN
          value:=hex.Data[hex.SelStart]+hex.Data[hex.SelStart+1]*256+hex.Data[hex.SelStart+2]*256*256+hex.Data[hex.SelStart+3]*256*256*256;
          value_viewer.Cells[1,i]:=IntToStr( value )+' / 0x'+IntToHex( value , 8 );
        END ELSE
          value_viewer.Cells[1,i]:='';
      END;
      IF value_viewer.Cells[0,i]='Bitset' THEN BEGIN
        IF (hex.SelCount<=8) THEN BEGIN
          IF hex.SelCount=0 THEN BEGIN
            SetLength(data,1);
            data[0]:=hex.Data[hex.SelStart];
          END ELSE BEGIN
            SetLength(data,hex.SelCount);
            FOR j:=0 TO hex.SelCount-1 DO
              data[j]:=hex.Data[hex.SelStart+j];
          END;
          value_viewer.Cells[1,i]:=DataToBin(data);
        END ELSE
          value_viewer.Cells[1,i]:='';
      END;
      IF value_viewer.Cells[0,i]='Float' THEN BEGIN
        IF ((hex.SelCount=4) OR (hex.SelCount=0)) AND NOT ((hex.SelStart+4)>hex.DataSize) THEN BEGIN
          SetLength(data,4);
          FOR j:=0 TO 3 DO
            data[j]:=hex.Data[hex.SelStart+j];
          value_viewer.Cells[1,i]:=FloatToStr(Decode_Float(data));
        END ELSE
          value_viewer.Cells[1,i]:='';
      END;
      IF value_viewer.Cells[0,i]='Selected length' THEN BEGIN
        value_viewer.Cells[1,i]:=IntToStr(hex.SelCount)+' bytes';
      END;
      IF value_viewer.Cells[0,i]='String' THEN BEGIN
        j:=0;
        str:='';
        IF hex.SelCount=0 THEN BEGIN
{          WHILE (hex.Data[hex.SelStart+j]>0) AND ((hex.SelStart+j)<hex.DataSize) DO BEGIN
            IF hex.Data[hex.selstart+j]>=32 THEN
              str:=str+Char(hex.Data[hex.SelStart+j])
            ELSE
              str:=str+'.';
            Inc(j);
          END;
}        END ELSE BEGIN
          FOR j:=1 TO hex.SelCount DO
            str:=str+Char(hex.Data[hex.SelStart+j-1]);
        END;
        value_viewer.Cells[1,i]:=str;
      END;
    END;
  END;

PROCEDURE TForm8.FormCreate(Sender: TObject);
  BEGIN
    Self.Caption:='';
    fileid:=0;
    structs.Height:=40;
    structs.ColCount:=5;
    structs.RowCount:=2;
    structs.FixedRows:=1;
    structs.Cells[0,0]:='Name';
    structs.Cells[1,0]:='Offset';
    structs.Cells[2,0]:='Type';
    structs.Cells[3,0]:='Value';
    structs.Cells[4,0]:='Description';
    structs.ColWidths[0]:=75;
    structs.ColWidths[1]:=60;
    structs.ColWidths[2]:=75;
    structs.ColWidths[3]:=75;
    value_viewer.ColCount:=2;
    value_viewer.RowCount:=8;
    value_viewer.FixedRows:=1;
    value_viewer.Cells[0,0]:='Type';
    value_viewer.Cells[1,0]:='Value';
    value_viewer.Cells[0,1]:='1 byte, unsigned';
    value_viewer.Cells[0,2]:='2 bytes, unsigned';
    value_viewer.Cells[0,3]:='4 bytes, unsigned';
    value_viewer.Cells[0,4]:='Bitset';
    value_viewer.Cells[0,5]:='Float';
    value_viewer.Cells[0,6]:='String';
    value_viewer.Cells[0,7]:='Selected length';
    value_viewer.ColWidths[0]:=100;
    hex.Height:=panel_data.Height-215;
    Self.panel_dataResize(Self);
  END;

FUNCTION TForm8.Save:Boolean;
  VAR
    mem:TMemoryStream;
    data:Tdata;
    i:LongWord;
  BEGIN
    CASE MessageBox(Self.Handle,PChar('Save changes to file '+GetFileInfo(fileid).FileName+'?'),PChar('Data changed...'),MB_YESNOCANCEL) OF
      IDYES: BEGIN
          mem:=TMemoryStream.Create;
          hex.SaveToStream(mem);
          mem.Seek(0,soFromBeginning);
          SetLength(data,mem.Size);
          mem.Read(data[0],mem.Size);
          mem.Free;
          UpdateDatFile(fileid,data);
          hex.Modified:=False;
          FOR i:=0 TO hex.Datasize-1 DO hex.ByteChanged[i]:=False;
          Result:=True;
        END;
      IDNO: Result:=True;
      IDCANCEL: BEGIN
          Result:=False;
        END;
    END;
  END;

PROCEDURE TForm8.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  BEGIN
    IF hex.Modified THEN BEGIN
      IF NOT Save THEN CanClose:=False;
    END;
  END;

PROCEDURE TForm8.ClearStructViewer;
  VAR
    x:Word;
  BEGIN
    structs.RowCount:=2;
    FOR x:=0 TO structs.ColCount-1 DO structs.Cells[x,1]:='';
    structs.Enabled:=False;
    structs.Height:=40;
  END;

PROCEDURE TForm8.FormResize(Sender: TObject);
  BEGIN
    IF Self.Width>=650 THEN BEGIN
    END ELSE Self.Width:=650;
    IF Self.Height>=450 THEN BEGIN
    END ELSE Self.Height:=450;
  END;

PROCEDURE TForm8.structsClick(Sender: TObject);
  VAR
    offset:LongWord;
    length:Byte;
  BEGIN
    IF structs.Row>0 THEN BEGIN
      offset:=structure_infos[GetStructureInfoId(GetFileInfo(fileid).extension)].entries[structs.Row-1].offset;
      length:=GetTypeDataLength(structure_infos[GetStructureInfoId(GetFileInfo(fileid).extension)].entries[structs.Row-1].datatype);
      hex.SelStart:=offset;
      hex.SelEnd:=offset+length-1;
    END;
  END;

PROCEDURE TForm8.panel_dataResize(Sender: TObject);
  BEGIN
    structs.ColWidths[4]:=structs.Width-structs.ColWidths[0]-structs.ColWidths[1]-structs.ColWidths[2]-structs.ColWidths[3]-28;
    value_viewer.ColWidths[1]:=value_viewer.Width-value_viewer.ColWidths[0]-28;
  END;

PROCEDURE TForm8.hexChange(Sender: TObject);
  BEGIN
    ClearValues;
    IF hex.DataSize>0 THEN BEGIN
      WriteStructureInfos(GetStructureInfoId(GetFileInfo(fileid).Extension));
      WriteValues;
    END;
  END;

PROCEDURE TForm8.hexSelectionChanged(Sender: TObject);
  VAR
    selstart:Integer;
    i,j:Word;
  BEGIN
    FOR i:=1 TO structs.RowCount-1 DO BEGIN
      FOR j:=0 TO structs.ColCount-1 DO BEGIN
        structs.CellColors[j,i]:=clWhite;
        structs.CellFontColors[j,i]:=clBlack;
      END;
    END;
    IF hex.DataSize>0 THEN BEGIN
      selstart:=hex.SelStart;
      IF GetStructureInfoId(GetFileInfo(fileid).Extension)>=0 THEN BEGIN
        WITH structure_infos[GetStructureInfoId(GetFileInfo(fileid).Extension)] DO BEGIN
          FOR i:=0 TO High(entries) DO BEGIN
            IF ((selstart-entries[i].offset)<GetTypeDataLength(entries[i].datatype)) AND ((selstart-entries[i].offset)>=0) THEN BEGIN
              FOR j:=0 TO structs.ColCount-1 DO BEGIN
                structs.CellColors[j,i+1]:=clBlue;
                structs.CellFontColors[j,i+1]:=clWhite;
              END;
              structs.Row:=i+1;
            END;
          END;
        END;
      END;
      WriteValues;
    END;
  END;

PROCEDURE TForm8.FormClose(Sender: TObject; var Action: TCloseAction);
  BEGIN
    Action:=caFree;
    Form1.close_window(Self.Name);
  END;

PROCEDURE TForm8.panel_imexportResize(Sender: TObject);
  BEGIN
    btn_import.Width:=panel_imexport.Width-8;
    btn_export.Width:=panel_imexport.Width-8;
  END;

PROCEDURE TForm8.btn_exportClick(Sender: TObject);
  BEGIN
    saved.Filter:='Files of matching extension (*.'+GetFileInfo(fileid).Extension+')|*.'+dat_files[fileid].Extension+'|All files|*.*';
    saved.DefaultExt:=GetFileInfo(fileid).Extension;
    IF saved.Execute THEN BEGIN
      ExportDatFile(fileid,saved.FileName);
    END;
  END;

PROCEDURE TForm8.btn_importClick(Sender: TObject);
  VAR
    data:Tdata;
    fs:TFileStream;
  BEGIN
    opend.Filter:='Files of matching extension (*.'+GetFileInfo(fileid).Extension+')|*.'+dat_files[fileid].Extension+'|All files|*.*';
    IF opend.Execute THEN BEGIN
      fs:=TFileStream.Create(opend.FileName,fmOpenRead);
      IF fs.Size<>hex.DataSize THEN BEGIN
        ShowMessage('Can''t import '+ExtractFilename(opend.FileName)+
                    ', file has to have same size as file in .dat.'+CrLf+
                    'Size of file in .dat: '+FormatFileSize(hex.datasize)+CrLf+
                    'Size of chosen file: '+FormatFileSize(fs.Size));
      END ELSE BEGIN
        hex.LoadFromStream(fs);
        hex.Modified:=True;
      END;
      fs.Free;
    END;
  END;

PROCEDURE TForm8.FormActivate(Sender: TObject);
  BEGIN
    Form1.SetActiveWindow(Self.Name);
  END;

PROCEDURE TForm8.value_viewer_contextPopup(Sender: TObject);
  VAR
    i:Byte;
  BEGIN
    FOR i:=0 TO value_viewer_context.Items.Count-1 DO
      value_viewer_context.Items.Items[i].Visible:=False;
    WITH value_viewer DO BEGIN
      IF (Col=1) AND (Row>0) AND (Length(Cells[Col,Row])>0) THEN BEGIN
        IF Pos(' byte',Cells[0,Row])=2 THEN BEGIN
          value_viewer_context.Items.Find('Copy to &clipboard').Visible:=True;
          value_viewer_context.Items.Find('Copy to clipboard (as &dec)').Visible:=True;
          value_viewer_context.Items.Find('Copy to clipboard (as &hex)').Visible:=True;
        END;
        IF Pos('Float',Cells[0,Row])=1 THEN
          value_viewer_context.Items.Find('Copy to clipboard (as &float)').Visible:=True;
        IF Pos('Bitset',Cells[0,Row])=1 THEN
          value_viewer_context.Items.Find('Copy to clipboard (as &bitset)').Visible:=True;
        IF Pos('String',Cells[0,Row])=1 THEN
          value_viewer_context.Items.Find('Copy to clipboard (as &string)').Visible:=True;
        IF Pos('Selected length',Cells[0,Row])=1 THEN
          value_viewer_context.Items.Find('Copy to &clipboard').Visible:=True;
      END;
    END;
  END;

PROCEDURE TForm8.value_viewerMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
  VAR
    ACol,ARow:Integer;
  BEGIN
    IF Button=mbRight THEN BEGIN
      value_viewer.MouseToCell(x,y,ACol,ARow);
      IF ARow>0 THEN BEGIN
        value_viewer.Col:=ACol;
        value_viewer.Row:=ARow;
      END;
    END;
  END;

PROCEDURE TForm8.value_viewer_context_copyClick(Sender: TObject);
  VAR
    i:Byte;
    name:String;
    value:LongWord;
  BEGIN
    name:=TMenuItem(Sender).Name;
    IF Pos('asstring',name)>0 THEN BEGIN
      Clipboard.AsText:=value_viewer.Cells[value_viewer.Col,value_viewer.Row];
    END ELSE
    IF Pos('asfloat',name)>0 THEN BEGIN
      Clipboard.AsText:=value_viewer.Cells[value_viewer.Col,value_viewer.Row];
    END ELSE
    IF Pos('asbitset',name)>0 THEN BEGIN
      Clipboard.AsText:=value_viewer.Cells[value_viewer.Col,value_viewer.Row];
    END ELSE
    IF (Pos('ashex',name)>0) OR (Pos('asdec',name)>0) THEN BEGIN
      IF value_viewer.Cells[0,value_viewer.Row]='1 byte, unsigned' THEN BEGIN
        IF ((hex.SelCount=1) OR (hex.SelCount=0)) AND NOT ((hex.SelStart+1)>hex.DataSize) THEN
          value:=hex.Data[hex.SelStart];
      END;
      IF value_viewer.Cells[0,value_viewer.Row]='2 bytes, unsigned' THEN BEGIN
        IF ((hex.SelCount=2) OR (hex.SelCount=0)) AND NOT ((hex.SelStart+2)>hex.DataSize) THEN
          value:=hex.Data[hex.SelStart] + hex.Data[hex.SelStart+1]*256;
      END;
      IF value_viewer.Cells[0,value_viewer.Row]='4 bytes, unsigned' THEN BEGIN
        IF ((hex.SelCount=4) OR (hex.SelCount=0)) AND NOT ((hex.SelStart+4)>hex.DataSize) THEN
          value:=hex.Data[hex.SelStart]+hex.Data[hex.SelStart+1]*256+hex.Data[hex.SelStart+2]*256*256+hex.Data[hex.SelStart+3]*256*256*256;
      END;
      IF Pos('asdec',name)>0 THEN BEGIN
        Clipboard.AsText:=IntToStr(value);
      END ELSE BEGIN
        IF value_viewer.Cells[0,value_viewer.Row]='1 byte, unsigned' THEN
          Clipboard.AsText:='0x'+IntToHex(value,2);
        IF value_viewer.Cells[0,value_viewer.Row]='2 bytes, unsigned' THEN
          Clipboard.AsText:='0x'+IntToHex(value,4);
        IF value_viewer.Cells[0,value_viewer.Row]='4 bytes, unsigned' THEN
          Clipboard.AsText:='0x'+IntToHex(value,8);
      END;
    END ELSE BEGIN
      Clipboard.AsText:=value_viewer.Cells[value_viewer.Col,value_viewer.Row];
    END;
  END;

PROCEDURE TForm8.structsDblClick(Sender: TObject);
  VAR
    offset:LongWord;
    datatype:Word;
    objectname:String;
    value:String;
  BEGIN
    IF (structs.Row>0) AND (structs.Cells[structs.Col,0]='Value') THEN BEGIN
      offset:=structure_infos[GetStructureInfoId(GetFileInfo(fileid).extension)].entries[structs.Row-1].offset;
      datatype:=structure_infos[GetStructureInfoId(GetFileInfo(fileid).extension)].entries[structs.Row-1].datatype;
      IF datatype<>11 THEN BEGIN
        objectname:=structure_infos[GetStructureInfoId(GetFileInfo(fileid).extension)].entries[structs.Row-1].name;
        value:=GetValue(datatype,offset);
        Form12.MakeVarInput(objectname,offset,datatype,value,Self);
      END ELSE BEGIN
        IF GetRawInfo(fileid,offset).raw_size>0 THEN BEGIN
        //edit_filtername.Text:=IntToStr(GetRawInfo(fileid,offset).raw_size);
          IF Form1.open_child('rawedit') THEN BEGIN
            TForm13(Form1.ActiveMDIChild).LoadRaw(GetRawInfo(fileid,offset));
          END;
        END;
        {LOAD RAW-EDITOR}
      END;
    END;
  END;

PROCEDURE TForm8.SetNewValue(datatype:Word; offset:LongWord; value:String);
  VAR
    data:Tdata;
    value_int:LongWord;
    value_float:Single;
    i:Word;
  BEGIN
    CASE datatype OF
      1..4: BEGIN
              value_int:=StrToInt(value);
              SetLength(data,datatype);
              FOR i:=0 TO datatype-1 DO BEGIN
                data[i]:=value_int MOD 256;
                value_int:=value_int DIV 256;
              END;
            END;
      5..8: BEGIN
              value_int:=StrToInt('$'+value);
              SetLength(data,datatype-4);
              FOR i:=0 TO datatype-5 DO BEGIN
                data[i]:=value_int MOD 256;
                value_int:=value_int DIV 256;
              END;
            END;
      9:    BEGIN
              value_float:=StrToFloat(value);
              data:=Encode_Float(value_float);
            END;
      10:   BEGIN
              value_int:=BinToInt(value);
              SetLength(data,1);
              data[0]:=value_int;
            END;
      10000..65535: BEGIN
              SetLength(data,datatype-10000);
              FOR i:=1 TO datatype-10000 DO BEGIN
                IF i<=Length(value) THEN
                  data[i-1]:=Ord(value[i])
                ELSE
                  data[i-1]:=0;
              END;
            END;
    END;
    FOR i:=0 TO High(data) DO BEGIN
      IF hex.Data[offset+i]<>data[i] THEN hex.ByteChanged[offset+i]:=True;
      hex.Data[offset+i]:=data[i];
    END;
    hex.Modified:=True;
    hexChange(Self);
    hex.Repaint;
  END;

PROCEDURE TForm8.value_viewerDblClick(Sender: TObject);
  VAR
    offset:LongWord;
    datatype:Word;
    objectname:String;
    value:String;
  BEGIN
    IF (value_viewer.Col=1) AND (Length(value_viewer.Cells[1,value_viewer.Row])>0) THEN BEGIN
      offset:=hex.SelStart;
      IF value_viewer.Cells[0,value_viewer.Row]='1 byte, unsigned' THEN
        datatype:=1;
      IF value_viewer.Cells[0,value_viewer.Row]='2 bytes, unsigned' THEN
        datatype:=2;
      IF value_viewer.Cells[0,value_viewer.Row]='4 bytes, unsigned' THEN
        datatype:=4;
      IF value_viewer.Cells[0,value_viewer.Row]='Bitset' THEN
        datatype:=10;
      IF value_viewer.Cells[0,value_viewer.Row]='Float' THEN
        datatype:=9;
      IF value_viewer.Cells[0,value_viewer.Row]='Selected length' THEN
        Exit;
      IF value_viewer.Cells[0,value_viewer.Row]='String' THEN BEGIN
        IF hex.SelCount>0 THEN
          datatype:=10000+hex.SelCount
        ELSE
          datatype:=10000+Length(value_viewer.Cells[1,value_viewer.Row]);
      END;
      objectname:='';
      value:=GetValue(datatype,offset);
      Form12.MakeVarInput(objectname,offset,datatype,value,Self);
    END;
  END;

PROCEDURE TForm8.FormKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
  BEGIN
    IF (Shift=[ssCtrl]) AND (Key=83) THEN
      IF hex.Modified THEN
        IF NOT Save THEN
          Exit;
  END;

END.
