UNIT Unit1_main;
INTERFACE
USES
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, StrUtils, Clipbrd, ExtCtrls, ComCtrls, Menus,
  Unit2_functions, Unit3_data, Unit5_preview, Unit7_txmpreplace, Unit8_binedit,
  Grids, MPHexEditor, ToolWin, ImgList, Tabs;

TYPE
  TForm1 = Class(TForm)
    fopen: TOpenDialog;
    menu: TMainMenu;
    menu_main: TMenuItem;
    menu_exit: TMenuItem;
    menu_preview: TMenuItem;
    menu_tools: TMenuItem;
    menu_txmpreplace: TMenuItem;
    menu_extract: TMenuItem;
    menu_extractfile: TMenuItem;
    menu_extractlist: TMenuItem;
    menu_extractall: TMenuItem;
    menu_loaddat: TMenuItem;
    menu_sep1: TMenuItem;
    menu_binedit: TMenuItem;
    statbar: TStatusBar;
    menu_windows: TMenuItem;
    menu_windows_cascade: TMenuItem;
    menu_windows_closeall: TMenuItem;
    menu_sep2: TMenuItem;
    menu_windows_tile: TMenuItem;
    menu_sep3: TMenuItem;
    menu_windows_next: TMenuItem;
    menu_windows_previous: TMenuItem;
    procedure menu_windows_previousClick(Sender: TObject);
    procedure menu_windows_nextClick(Sender: TObject);
    procedure menu_windows_tileClick(Sender: TObject);
    PROCEDURE open_child(window_context:String);
    PROCEDURE menu_windows_closeallClick(Sender: TObject);
    PROCEDURE menu_windows_cascadeClick(Sender: TObject);
    PROCEDURE menu_window_entryClick(Sender: TObject);
    PROCEDURE menu_bineditClick(Sender: TObject);
    PROCEDURE menu_loaddatClick(Sender: TObject);
    PROCEDURE menu_txmpreplaceClick(Sender: TObject);
    PROCEDURE menu_exitClick(Sender: TObject);
    PROCEDURE menu_previewClick(Sender: TObject);
    PROCEDURE FormClose(Sender: TObject; var Action: TCloseAction);
    PROCEDURE FormResize(Sender: TObject);
    PROCEDURE FormCreate(Sender: TObject);
  PRIVATE
  PUBLIC
  END;

VAR
  Form1: TForm1;

IMPLEMENTATION
{$R *.dfm}

PROCEDURE LoadDat;
  VAR i:LongWord;
  BEGIN
    Form1.fopen.InitialDir:=AppSettings.DatPath;
    IF Form1.fopen.Execute THEN BEGIN
      Form1.Caption:='Oni Un/Packer '+version+' ('+ExtractFileName(Form1.fopen.FileName)+')';
      AppSettings.DatPath:=ExtractFilepath(Form1.fopen.FileName);
      IF LoadDatInfos(Form1.fopen.FileName) THEN BEGIN
        Form1.statbar.Panels.Items[0].Text:='Current .dat: '+dat_FileName;
        Form1.statbar.Panels.Items[1].Text:='Files: '+IntToStr(dat_header.Files);
        Form1.statbar.Panels.Items[2].Text:='Extensions: '+IntToStr(dat_header.Extensions);
        Form1.menu_tools.Enabled:=True;
        Form1.menu_extract.Enabled:=True;

        IF Form1.MDIChildCount>0 THEN
          FOR i:=0 TO Form1.MDIChildCount-1 DO BEGIN
            IF Pos('binedit',Form1.MDIChildren[i].Name)>0 THEN
              TForm8(Form1.MDIChildren[i]).Recreatelist;
            IF Pos('preview',Form1.MDIChildren[i].Name)>0 THEN
              TForm5(Form1.MDIChildren[i]).Recreatelist;
            IF Pos('txmpreplace',Form1.MDIChildren[i].Name)>0 THEN
              TForm7(Form1.MDIChildren[i]).Recreatelist;
          END;
      END ELSE BEGIN
        ShowMessage('Error while loading the file:'+CrLf+Form1.fopen.FileName+CrLf+'Perhaps not an Oni-.dat-file?');
      END;
    END;
  END;

PROCEDURE TForm1.FormCreate(Sender: TObject);
  BEGIN
    Form1.Caption:='Oni Un/Packer '+version;
    Form1.FormResize(Form1);

    IF FileExists(ExtractFilepath(Application.EXEname)+'\oniunpacker.ini') THEN BEGIN
      AssignFile(AppSettingsFile,ExtractFilepath(Application.EXEname)+'\oniunpacker.ini');
      Reset(AppSettingsFile);
      Read(AppSettingsFile,AppSettings);
      CloseFile(AppSettingsFile);
    END ELSE BEGIN
      AppSettings.DatPath:='D:\Spiele\Oni\GameDataFolder';
      AppSettings.ExtractPath:='C:\Dokumente und Einstellungen\Administrator\Desktop';
    END;
  END;

PROCEDURE TForm1.FormResize(Sender: TObject);
  CONST
    MinWidth:Integer=750;
    MinHeight:Integer=500;
  BEGIN
    IF Form1.Width<MinWidth THEN Form1.Width:=MinWidth;
    IF Form1.Height<MinHeight THEN Form1.Height:=MinHeight;
    Form1.statbar.Panels.Items[0].Width:=Form1.Width-200;
  END;

PROCEDURE TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
  BEGIN
    AssignFile(AppSettingsFile,ExtractFilepath(Application.EXEname)+'\oniunpacker.ini');
    IF FileExists(ExtractFilepath(Application.EXEname)+'\oniunpacker.ini') THEN
      Reset(AppSettingsFile)
    ELSE
      Rewrite(AppSettingsFile);
    Write(AppSettingsFile,AppSettings);
    CloseFile(AppSettingsFile);
    Action:=caFree;
  END;


{##### Main-Menu-Handlers #####}
PROCEDURE TForm1.menu_loaddatClick(Sender: TObject);
  BEGIN
    LoadDat;
  END;
PROCEDURE TForm1.menu_exitClick(Sender: TObject);
  BEGIN
    Form1.Close;
  END;

{##### Tools-Menu-Handlers #####}
PROCEDURE TForm1.menu_previewClick(Sender: TObject);
  BEGIN
    open_child('preview');
  END;
PROCEDURE TForm1.menu_txmpreplaceClick(Sender: TObject);
  BEGIN
    open_child('txmpreplace');
  END;
PROCEDURE TForm1.menu_bineditClick(Sender: TObject);
  BEGIN
    open_child('binedit');
  END;

{##### Window-Menu-Handlers #####}
PROCEDURE TForm1.menu_windows_cascadeClick(Sender: TObject);
  BEGIN
    Form1.Cascade;
  END;
PROCEDURE TForm1.menu_windows_closeallClick(Sender: TObject);
  VAR
    i:Byte;
  BEGIN
    IF MDIChildCount>0 THEN BEGIN
      FOR i:=0 TO MDIChildCount-1 DO BEGIN
        MDIChildren[i].Close;
      END;
    END;
  END;
PROCEDURE TForm1.menu_window_entryClick(Sender: TObject);
  VAR
    i:Byte;
    window_name:String;
  BEGIN
    window_name:=MidStr(TComponent(Sender).Name,Pos('window_',TComponent(Sender).Name)+7,Length(TComponent(Sender).Name)-Pos('window_',TComponent(Sender).Name)+7+1);
    FOR i:=0 TO MDIChildCount-1 DO BEGIN
      IF MDIChildren[i].Name=window_name THEN BEGIN
        MDIChildren[i].BringToFront;
      END;
    END;
  END;



PROCEDURE TForm1.open_child(window_context:String);
  VAR
    binEdit:TForm8;
    preview:TForm5;
    txmpreplacer:TForm7;
    menu_button:TMenuItem;
    used:Array[1..9] OF Boolean;
    i,j:Byte;
    caption:String;
    name:String;
  BEGIN
    FOR i:=1 TO 9 DO used[i]:=False;
    IF MDIChildCount>0 THEN
      FOR i:=0 TO MDIChildCount-1 DO
        IF Pos(window_context,Form1.MDIChildren[i].Name)=1 THEN
          used[StrToInt(RightStr(Form1.MDIChildren[i].Caption,1))]:=True;
    FOR i:=1 TO 10 DO
      IF i=10 THEN
        Break
      ELSE
        IF NOT used[i] THEN Break;
    IF i<10 THEN BEGIN
      name:=window_context+IntToStr(i);
      IF window_context='binedit' THEN BEGIN
        caption:='Binary .dat-Editor '+IntToStr(i);
        binEdit:=TForm8.Create(Application);
        binEdit.Name:=name;
        binEdit.Caption:=caption;
        binEdit.Recreatelist;
      END;
      IF window_context='preview' THEN BEGIN
        caption:='Preview-Window '+IntToStr(i);
        preview:=TForm5.Create(Application);
        preview.Name:=name;
        preview.Caption:=caption;
        preview.Recreatelist;
      END;
      IF window_context='txmpreplace' THEN BEGIN
        caption:='TXMP Replacer '+IntToStr(i);
        txmpreplacer:=TForm7.Create(Application);
        txmpreplacer.Name:=name;
        txmpreplacer.Caption:=caption;
        txmpreplacer.Recreatelist;
      END;

      menu_button:=TMenuItem.Create(menu_windows);
      menu_button.Caption:=caption;
      menu_button.Name:='menu_window_'+name;
      menu_button.OnClick:=Form1.menu_window_entryClick;
      FOR j:=0 TO menu_windows.Count DO BEGIN
        IF j<menu_windows.Count THEN BEGIN
          IF Pos(window_context,menu_windows.Items[j].Name)>0 THEN BEGIN
            IF StrToInt(RightStr(menu_windows.Items[j].Name,1))>i THEN BEGIN
              menu_windows.Insert(j,menu_button);
              Break;
            END;
          END;
        END ELSE BEGIN
          menu_windows.Add(menu_button);
        END;
      END;
      IF MDIChildCount=9 THEN menu_tools.Enabled:=False;
    END;
  END;


PROCEDURE TForm1.menu_windows_tileClick(Sender: TObject);
  BEGIN
    Form1.TileMode:=tbHorizontal;
    Form1.Tile;
  END;

PROCEDURE TForm1.menu_windows_nextClick(Sender: TObject);
  VAR i:Byte;
    first_window:Byte;
    current_focus:String;
  BEGIN
    IF MDIChildCount>1 THEN BEGIN
      FOR i:=0 TO menu_windows.Count-1 DO BEGIN
        IF Pos('menu_window_',menu_windows.Items[i].Name)=1 THEN BEGIN
          first_window:=i;
          Break;
        END;
      END;
      current_focus:=ActiveMDIChild.Name;
      FOR i:=first_window TO menu_windows.Count-1 DO
        IF Pos(current_focus,menu_windows.Items[i].Name)>0 THEN
          Break;
      IF i=menu_windows.Count-1 THEN
        menu_windows.Items[first_window].Click
      ELSE
        menu_windows.Items[i+1].Click;
    END;
  END;

PROCEDURE TForm1.menu_windows_previousClick(Sender: TObject);
  VAR i:Byte;
    first_window:Byte;
    current_focus:String;
  BEGIN
    IF MDIChildCount>1 THEN BEGIN
      FOR i:=0 TO menu_windows.Count-1 DO BEGIN
        IF Pos('menu_window_',menu_windows.Items[i].Name)=1 THEN BEGIN
          first_window:=i;
          Break;
        END;
      END;
      current_focus:=ActiveMDIChild.Name;
      FOR i:=first_window TO menu_windows.Count-1 DO
        IF Pos(current_focus,menu_windows.Items[i].Name)>0 THEN
          Break;
      IF i=first_window THEN
        menu_windows.Items[menu_windows.Count-1].Click
      ELSE
        menu_windows.Items[i-1].Click;
    END;
  END;

END.
