UNIT Unit10_leveldb;
INTERFACE
USES
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, StrUtils;

TYPE
  TForm10 = Class(TForm)
    group_progress: TGroupBox;
    progress: TProgressBar;
    lbl_progress: TLabel;
    btn_abortok: TButton;
    lbl_estimation: TLabel;
    PROCEDURE btn_abortokClick(Sender: TObject);
  PRIVATE
    PROCEDURE HandleFile(ext:String; fileid:LongWord; dir_dat2db:Boolean);
    PROCEDURE stop_convert;
  PUBLIC
    PROCEDURE CreateDatabase(source,target:String);
    PROCEDURE CreateLevel(source,target:String);
  END;


VAR
  Form10: TForm10;

IMPLEMENTATION
{$R *.dfm}
USES ABSMain, ABSDecUtil, Unit1_main, Unit2_functions, Unit3_data, Unit9_data_structures, Unit15_Classes;

TYPE
  THandler=PROCEDURE(fileid:LongWord; dir_dat2db:Boolean);
  TConvertHandlers=RECORD
    Ext:String[4];
    needed:Boolean;
    Handler:THandler;
  END;
VAR
  ConvertHandlers:Array OF TConvertHandlers;
  loaded_filename:String;
  converting:Boolean=False;
  abort:Boolean=False;
  DataBase:TABSDatabase;
  Query:TABSQuery;
  MimeCoder: TStringFormat_MIME64;

PROCEDURE TForm10.HandleFile;
  VAR
    i:Byte;
  BEGIN
    FOR i:=1 TO Length(ConvertHandlers) DO
      IF UpperCase(ConvertHandlers[i].Ext)=UpperCase(ext) THEN
        IF ConvertHandlers[i].needed THEN BEGIN
          ConvertHandlers[i].Handler(fileid, dir_dat2db);
          Break;
        END ELSE
          Break;
  END;

PROCEDURE TForm10.CreateLevel(source,target:String);
  VAR
    i:LongWord;
  BEGIN
  END;

PROCEDURE TForm10.CreateDatabase(source,target:String);
  VAR
    i,j:LongWord;
    temps,temps2:String;
    data:Tdata;
    absolutebegintime,begintime:Double;
    step:Byte;
    rawlist:TRawList;
    extlist:TExtensionsMap;
    fileinfo:TFileInfo;
  CONST
    steps:Byte=4;
  PROCEDURE DoStep(stepname:String);
    BEGIN
      Inc(step);
      IF stepname<>'FIN' THEN
        group_progress.Caption:='Creating DB (Step '+IntToStr(step)+'/'+IntToStr(steps)+': '+stepname+')'
      ELSE
        group_progress.Caption:='Creating DB (FINISHED)';
    END;
  BEGIN
    IF NOT CreateDataConnection(source,ODB_Dat) THEN BEGIN
      ShowMessage('Could not connect to .dat-file');
      Exit;
    END ELSE BEGIN
      TOniDataDat(OniDataConnection).UnloadWhenUnused:=False;
    END;

    Form10.Visible:=True;
    Form1.Visible:=False;
    step:=0;
    converting:=True;
    abort:=False;
    btn_abortok.Caption:='&Abort...';
    btn_abortok.Default:=False;
    loaded_filename:=target;

    absolutebegintime:=Time;

    DataBase:=TABSDatabase.Create(Self);
    DataBase.DatabaseName:='OLDB';
    DataBase.DatabaseFileName:=target;
    DataBase.CreateDatabase;

    DoStep('Creating tables');
    progress.Position:=0;
    lbl_progress.Caption:='';
    lbl_estimation.Caption:='Estimated finishing time: unknown';
    Application.ProcessMessages;

    Query:=TABSQuery.Create(Self);
    Query.DatabaseName:='OLDB';
    Query.SQL.Text:='CREATE TABLE globals  ( id AUTOINC PRIMARY KEY, name STRING(128), value STRING(128) );';
    Query.ExecSQL;
    Query.SQL.Text:='CREATE TABLE linkmap  ( id AUTOINC PRIMARY KEY, src_id INTEGER, src_link_offset INTEGER, target_id INTEGER );';
    Query.ExecSQL;
    Query.SQL.Text:='CREATE TABLE rawmap  ( id AUTOINC PRIMARY KEY, src_id INTEGER, src_link_offset INTEGER, size INTEGER, data BLOB BlobCompressionMode 9 BlobBlockSize 1024 BlobCompressionAlgorithm ZLib );';
//    Query.SQL.Text:='CREATE TABLE rawmap  ( id AUTOINC PRIMARY KEY, src_id INTEGER, src_link_offset INTEGER, size INTEGER, data BLOB BlobCompressionAlgorithm None );';
    Query.ExecSQL;
    Query.SQL.Text:='CREATE TABLE datfiles  ( id INTEGER PRIMARY KEY, extension CHAR(4), name STRING(128), contenttype INTEGER, size INTEGER, data BLOB BlobCompressionMode 9 BlobBlockSize 1024 BlobCompressionAlgorithm ZLib );';
//    Query.SQL.Text:='CREATE TABLE datfiles  ( id INTEGER PRIMARY KEY, extension CHAR(4), name STRING(128), contenttype INTEGER, size INTEGER, data BLOB BlobCompressionAlgorithm None );';
    Query.ExecSQL;
    Query.SQL.Text:='CREATE TABLE extlist  ( id AUTOINC PRIMARY KEY, ext CHAR(4), ident CHAR(16) );';
    Query.ExecSQL;

    Query.SQL.Text:='INSERT INTO globals (name,value) VALUES ("dbversion","'+dbversion+'");';
    Query.ExecSQL;
    SetLength(data,Length(OniDataConnection.LevelInfo.Ident));
    FOR i:=0 TO High(OniDataConnection.LevelInfo.Ident) DO data[i]:=OniDataConnection.LevelInfo.Ident[i];
    temps:=CreateHexString(data,True);
    Query.SQL.Text:='INSERT INTO globals (name,value) VALUES ("ident","'+temps+'");';
    Query.ExecSQL;
    Query.SQL.Text:='INSERT INTO globals (name,value) VALUES ("lvl","'+IntToStr(OniDataConnection.LevelInfo.LevelNumber)+'");';
    Query.ExecSQL;
    IF OniDataConnection.OSisMAC THEN
      Query.SQL.Text:='INSERT INTO globals (name,value) VALUES ("os","MAC");'
    ELSE
      Query.SQL.Text:='INSERT INTO globals (name,value) VALUES ("os","PC");';
    Query.ExecSQL;

    DoStep('Writing extensionslist');
    progress.Max:=Length(OniDataConnection.GetExtensionsList);
    Application.ProcessMessages;

    extlist:=OniDataConnection.GetExtendedExtensionsList;
    FOR i:=0 TO High(extlist) DO BEGIN
      SetLength(data,Length(extlist[i].Ident));
      FOR j:=0 TO High(extlist[i].Ident) DO data[j]:=extlist[i].Ident[j];
      temps:=CreateHexString(data,True);
      temps2:=extlist[i].Extension[3]+extlist[i].Extension[2]+extlist[i].Extension[1]+extlist[i].Extension[0];
      Query.SQL.Text:='INSERT INTO extlist (ext,ident) VALUES ("'+temps2+'","'+temps+'");';
      Query.ExecSQL;
      progress.Position:=i;
      lbl_progress.Caption:='Extensions done: '+IntToStr(i)+'/'+IntToStr(Length(extlist));
      Application.ProcessMessages;
      IF abort THEN BEGIN
        stop_convert;
        Exit;
      END;
    END;
    lbl_progress.Caption:='';

    progress.Position:=0;
    lbl_progress.Caption:='Files done: '+IntToStr(0)+'/'+IntToStr(OniDataConnection.GetFilesCount);
    lbl_estimation.Caption:='Estimated finishing time: unknown';

    DoStep('Loading .dat into memory');
    Application.ProcessMessages;

    progress.Max:=OniDataConnection.GetFilesCount;
    begintime:=Time;
    DoStep('Writing .dat-fileslist');
    Application.ProcessMessages;

    Database.StartTransaction;
    FOR i:=0 TO OniDataConnection.GetFilesCount-1 DO BEGIN
      fileinfo:=OniDataConnection.GetFileInfo(i);
      IF (fileinfo.FileType AND $02)=0 THEN BEGIN
        mimecoder:=TStringFormat_MIME64.Create;
        data:=OniDataConnection.LoadDatFile(i);
        Query.SQL.Text:='INSERT INTO datfiles (id,extension,name,contenttype,size,data) VALUES ('+IntToStr(i)+',"'+fileinfo.Extension+'","'+fileinfo.Name+'","'+IntToHex(fileinfo.FileType,8)+'",'+IntToStr(fileinfo.Size)+',MimeToBin("'+MimeCoder.StrTo(@data[0], Length(data))+'") );';
        Query.ExecSQL;
        mimecoder.Free;

        rawlist:=OniDataConnection.GetRawList(i);
        IF Length(rawlist)>0 THEN BEGIN
          FOR j:=0 TO High(rawlist) DO BEGIN
            IF rawlist[j].raw_size>0 THEN BEGIN
              SetLength(data, rawlist[j].raw_size);
              OniDataConnection.LoadRawFile(i,rawlist[j].src_offset,data);
              mimecoder:=TStringFormat_MIME64.Create;
              Query.SQL.Text:='INSERT INTO rawmap (src_id,src_link_offset,size,data) VALUES ('+IntToStr(i)+','+IntToStr(rawlist[j].src_offset)+','+IntToStr(rawlist[j].raw_size)+',MimeToBin("'+MimeCoder.StrTo(@data[0], rawlist[j].raw_size)+'") );';
              Query.ExecSQL;
              mimecoder.Free;
            END ELSE BEGIN
              Query.SQL.Text:='INSERT INTO rawmap (src_id,src_link_offset,size) VALUES ('+IntToStr(i)+','+IntToStr(rawlist[j].src_offset)+',0);';
              Query.ExecSQL;
            END;
          END;
        END;

        HandleFile(fileinfo.Extension,i,True);
      END ELSE BEGIN
        Query.SQL.Text:='INSERT INTO datfiles (id,extension,name,contenttype,size) VALUES ('+IntToStr(i)+',"'+fileinfo.Extension+'","'+fileinfo.Name+'","'+IntToHex(fileinfo.FileType,8)+'",0);';
        Query.ExecSQL;
      END;
      IF ( (i MOD 100)=0 ) AND (i>0) THEN BEGIN
        Database.Commit(False);
        Database.StartTransaction;
      END;
      IF ( (i MOD 25)=0 ) AND (i>=100) THEN
        lbl_estimation.Caption:='Estimated finishing time: '+TimeToStr((Time-begintime)/i*progress.Max+begintime);
      progress.Position:=i;
      lbl_progress.Caption:='Files done: '+IntToStr(i)+'/'+IntToStr(progress.Max);
      Application.ProcessMessages;
      IF abort THEN BEGIN
        stop_convert;
        Exit;
      END;
    END;
    Database.Commit(False);
    progress.Position:=progress.Max;
    lbl_progress.Caption:='Files done: '+IntToStr(progress.Max)+'/'+IntToStr(progress.Max);
    lbl_estimation.Caption:='FINISHED (duration: '+TimeToStr(Time-absolutebegintime)+')';

    DoStep('FIN');
    btn_abortok.Caption:='&OK';
    btn_abortok.Default:=True;

    converting:=False;

    database.Close;
    database.Free;

    CloseDataConnection;
  END;

PROCEDURE TForm10.stop_convert;
  BEGIN
    btn_abortok.Caption:='&Close';
    btn_abortok.Default:=True;
    converting:=False;
    lbl_estimation.Caption:='ABORTED';
    group_progress.Caption:='Creating DB (ABORTED)';
    DataBase.Close;
    IF MessageBox(Self.Handle, PChar('Delete the unfinished DB-file?'), PChar('Delete file?'), MB_YESNO)=IDYES THEN BEGIN
      DeleteFile(loaded_filename);
    END;
  END;

PROCEDURE TForm10.btn_abortokClick(Sender: TObject);
  BEGIN
    IF converting THEN BEGIN
      IF MessageBox(Self.Handle, PChar('Do you really want to cancel the convert-progress?'), PChar('Warning: Converting'), MB_YESNO)=IDYES THEN
        abort:=True;
    END ELSE BEGIN
      Form10.Visible:=False;
      Form1.Visible:=True;
    END;
  END;

PROCEDURE InsertDatLinkToDB(fileid:LongWord; offset:LongWord);
  VAR
    link:LongWord;
  BEGIN
    OniDataConnection.LoadDatFilePart(fileid,offset,4,@link);
    IF link=0 THEN
      link:=$FFFFFFFF
    ELSE
      link:=link DIV 256;
    Query.SQL.Text:='INSERT INTO linkmap (src_id,src_link_offset,target_id) VALUES ('+IntToStr(fileid)+','+IntToStr(offset)+','+IntToStr(link)+');';
    Query.ExecSQL;
  END;
(*
PROCEDURE InsertRawFileToDB(fileid:LongWord; src_offset,raw_addr,size:LongWord);
  VAR
    localmem:TMemoryStream;
//    temps:String;
  BEGIN
    IF size>0 THEN BEGIN
      localmem:=TMemoryStream.Create;
      filestream:=TFileStream.Create(raw_filename,fmOpenRead);
      filestream.Seek(raw_addr,soFromBeginning);
      localmem.CopyFrom(filestream,size);
      filestream.Free;
      mimecoder:=TStringFormat_MIME64.Create;
      Query.SQL.Text:='INSERT INTO rawmap (src_id,src_link_offset,size,data) VALUES ('+IntToStr(fileid)+','+IntToStr(src_offset)+','+IntToStr(size)+',MimeToBin("'+MimeCoder.StrTo(localmem.Memory, localmem.Size)+'") );';
      Query.ExecSQL;
      localmem.Free;
      mimecoder.Free;
    END ELSE BEGIN
      Query.SQL.Text:='INSERT INTO rawmap (src_id,src_link_offset,size) VALUES ('+IntToStr(fileid)+','+IntToStr(src_offset)+',0);';
      Query.ExecSQL;
    END;
{    IF (raw_addr MOD 32)>0 THEN BEGIN
      temps:='FileID='+FormatNumber(fileid,5,'0')+' - dat-Offset=0x'+IntToHex(src_offset,8)+' - raw-address=0x'+IntToHex(raw_addr,8)+#13+#10;
      filestream:=TFileStream.Create('D:\not32.txt',fmOpenReadWrite);
      filestream.Seek(0,soFromEnd);
      filestream.Write(temps[1],Length(temps));
      filestream.Free;
    END; }
  END;
*)


PROCEDURE AKEV(fileid:LongWord; dir_dat2db:Boolean);
  VAR
    i:LongWord;
  BEGIN
    IF dir_dat2db THEN BEGIN
      FOR i:=0 TO 16 DO InsertDatLinkToDB(fileid,$8+i*4);
    END ELSE BEGIN
    END;
  END;
PROCEDURE AKOT(fileid:LongWord; dir_dat2db:Boolean);
  VAR
    i:LongWord;
  BEGIN
    IF dir_dat2db THEN BEGIN
      FOR i:=0 TO 4 DO InsertDatLinkToDB(fileid,$8+i*4);
    END ELSE BEGIN
    END;
  END;
PROCEDURE CBPI(fileid:LongWord; dir_dat2db:Boolean);
  VAR
    i:LongWord;
  BEGIN
    IF dir_dat2db THEN BEGIN
      FOR i:=0 TO 56 DO InsertDatLinkToDB(fileid,$8+i*4);
    END ELSE BEGIN
    END;
  END;
PROCEDURE CBPM(fileid:LongWord; dir_dat2db:Boolean);
  VAR
    i:LongWord;
  BEGIN
    IF dir_dat2db THEN BEGIN
      FOR i:=0 TO 18 DO InsertDatLinkToDB(fileid,$8+i*4);
    END ELSE BEGIN
    END;
  END;
PROCEDURE CONS(fileid:LongWord; dir_dat2db:Boolean);
  VAR
    i:LongWord;
  BEGIN
    IF dir_dat2db THEN BEGIN
      FOR i:=0 TO 1 DO InsertDatLinkToDB(fileid,$24+i*4);
    END ELSE BEGIN
    END;
  END;
PROCEDURE CRSA(fileid:LongWord; dir_dat2db:Boolean);
  VAR
    packages:LongWord;
    i:LongWord;
  BEGIN
    IF dir_dat2db THEN BEGIN
      OniDataConnection.LoadDatFilePart(fileid,$14,4,@packages);
      IF packages>0 THEN
        FOR i:=0 TO packages-1 DO InsertDatLinkToDB(fileid,$20+i*1100+$A0);
    END ELSE BEGIN
    END;
  END;
PROCEDURE DOOR(fileid:LongWord; dir_dat2db:Boolean);
  BEGIN
    IF dir_dat2db THEN BEGIN
      InsertDatLinkToDB(fileid,$08);
      InsertDatLinkToDB(fileid,$10);
    END ELSE BEGIN
    END;
  END;
PROCEDURE DPGE(fileid:LongWord; dir_dat2db:Boolean);
  BEGIN
    IF dir_dat2db THEN BEGIN
      InsertDatLinkToDB(fileid,$40);
    END ELSE BEGIN
    END;
  END;
PROCEDURE HPGE(fileid:LongWord; dir_dat2db:Boolean);
  BEGIN
    IF dir_dat2db THEN BEGIN
      InsertDatLinkToDB(fileid,$0C);
    END ELSE BEGIN
    END;
  END;
PROCEDURE IGHH(fileid:LongWord; dir_dat2db:Boolean);
  BEGIN
    IF dir_dat2db THEN BEGIN
      InsertDatLinkToDB(fileid,$24);
      InsertDatLinkToDB(fileid,$28);
    END ELSE BEGIN
    END;
  END;
PROCEDURE IGPA(fileid:LongWord; dir_dat2db:Boolean);
  VAR
    links:LongWord;
    i:LongWord;
  BEGIN
    IF dir_dat2db THEN BEGIN
      OniDataConnection.LoadDatFilePart(fileid,$1C,4,@links);
      IF links>0 THEN
        FOR i:=0 TO links-1 DO InsertDatLinkToDB(fileid,$20+i*4);
    END ELSE BEGIN
    END;
  END;
PROCEDURE IGPG(fileid:LongWord; dir_dat2db:Boolean);
  VAR
    i:LongWord;
  BEGIN
    IF dir_dat2db THEN BEGIN
      FOR i:=0 TO 1 DO InsertDatLinkToDB(fileid,$1C+i*4);
    END ELSE BEGIN
    END;
  END;
PROCEDURE IGSA(fileid:LongWord; dir_dat2db:Boolean);
  VAR
    links:LongWord;
    i:LongWord;
  BEGIN
    IF dir_dat2db THEN BEGIN
      OniDataConnection.LoadDatFilePart(fileid,$1C,4,@links);
      IF links>0 THEN
        FOR i:=0 TO links-1 DO InsertDatLinkToDB(fileid,$20+i*4);
    END ELSE BEGIN
    END;
  END;
PROCEDURE IMPT(fileid:LongWord; dir_dat2db:Boolean);
  BEGIN
    IF dir_dat2db THEN BEGIN
      InsertDatLinkToDB(fileid,$10);
    END ELSE BEGIN
    END;
  END;
PROCEDURE IPGE(fileid:LongWord; dir_dat2db:Boolean);
  BEGIN
    IF dir_dat2db THEN BEGIN
      InsertDatLinkToDB(fileid,$0C);
    END ELSE BEGIN
    END;
  END;
PROCEDURE KEYI(fileid:LongWord; dir_dat2db:Boolean);
  VAR
    i:LongWord;
  BEGIN
    IF dir_dat2db THEN BEGIN
      FOR i:=0 TO 9 DO InsertDatLinkToDB(fileid,$08+i*4);
    END ELSE BEGIN
    END;
  END;
PROCEDURE M3GA(fileid:LongWord; dir_dat2db:Boolean);
  VAR
    links:LongWord;
    i:LongWord;
  BEGIN
    IF dir_dat2db THEN BEGIN
      OniDataConnection.LoadDatFilePart(fileid,$1C,4,@links);
      IF links>0 THEN
        FOR i:=0 TO links-1 DO InsertDatLinkToDB(fileid,$20+i*4);
    END ELSE BEGIN
    END;
  END;
PROCEDURE M3GM(fileid:LongWord; dir_dat2db:Boolean);
  VAR
    i:LongWord;
  BEGIN
    IF dir_dat2db THEN BEGIN
      FOR i:=0 TO 6 DO InsertDatLinkToDB(fileid,$0C+i*4);
    END ELSE BEGIN
    END;
  END;
PROCEDURE MTRL(fileid:LongWord; dir_dat2db:Boolean);
  BEGIN
    IF dir_dat2db THEN BEGIN
      InsertDatLinkToDB(fileid,$10);
    END ELSE BEGIN
    END;
  END;
PROCEDURE OBOA(fileid:LongWord; dir_dat2db:Boolean);
  VAR
    packages:Word;
    i:LongWord;
  BEGIN
    IF dir_dat2db THEN BEGIN
      OniDataConnection.LoadDatFilePart(fileid,$1E,2,@packages);
      IF packages>0 THEN
        FOR i:=0 TO packages-1 DO InsertDatLinkToDB(fileid,$20+i*240);
    END ELSE BEGIN
    END;
  END;
PROCEDURE OFGA(fileid:LongWord; dir_dat2db:Boolean);
  VAR
    packages:LongWord;
    i:LongWord;
  BEGIN
    IF dir_dat2db THEN BEGIN
      OniDataConnection.LoadDatFilePart(fileid,$1C,4,@packages);
      IF packages>0 THEN
        FOR i:=0 TO packages-1 DO InsertDatLinkToDB(fileid,$20+i*12+$04);
    END ELSE BEGIN
    END;
  END;
PROCEDURE ONCC(fileid:LongWord; dir_dat2db:Boolean);
  VAR
    i:LongWord;
  BEGIN
    IF dir_dat2db THEN BEGIN
    END ELSE BEGIN
    END;
  END;
PROCEDURE ONCV(fileid:LongWord; dir_dat2db:Boolean);
  BEGIN
    IF dir_dat2db THEN BEGIN
      InsertDatLinkToDB(fileid,$08);
    END ELSE BEGIN
    END;
  END;
PROCEDURE ONLV(fileid:LongWord; dir_dat2db:Boolean);
  VAR
    i:LongWord;
  BEGIN
    IF dir_dat2db THEN BEGIN
      FOR i:=0 TO 5 DO InsertDatLinkToDB(fileid,$48+i*4);
      FOR i:=0 TO 5 DO InsertDatLinkToDB(fileid,$64+i*4);
      InsertDatLinkToDB(fileid,$300);
    END ELSE BEGIN
    END;
  END;
PROCEDURE ONOA(fileid:LongWord; dir_dat2db:Boolean);
  VAR
    packages:LongWord;
    i:LongWord;
  BEGIN
    IF dir_dat2db THEN BEGIN
      OniDataConnection.LoadDatFilePart(fileid,$1C,4,@packages);
      IF packages>0 THEN
        FOR i:=0 TO packages-1 DO InsertDatLinkToDB(fileid,$20+i*8+$04);
    END ELSE BEGIN
    END;
  END;
PROCEDURE ONSK(fileid:LongWord; dir_dat2db:Boolean);
  BEGIN
    IF dir_dat2db THEN BEGIN
      InsertDatLinkToDB(fileid,$08);
      InsertDatLinkToDB(fileid,$0C);
      InsertDatLinkToDB(fileid,$10);
      InsertDatLinkToDB(fileid,$14);
      InsertDatLinkToDB(fileid,$18);
      InsertDatLinkToDB(fileid,$20);
      InsertDatLinkToDB(fileid,$44);
    END ELSE BEGIN
    END;
  END;
PROCEDURE ONVL(fileid:LongWord; dir_dat2db:Boolean);
  VAR
    packages:LongWord;
    i:LongWord;
  BEGIN
    IF dir_dat2db THEN BEGIN
      OniDataConnection.LoadDatFilePart(fileid,$1C,4,@packages);
      IF packages>0 THEN
        FOR i:=0 TO packages-1 DO InsertDatLinkToDB(fileid,$20+i*4);
    END ELSE BEGIN
    END;
  END;
PROCEDURE ONWC(fileid:LongWord; dir_dat2db:Boolean);
  BEGIN
    IF dir_dat2db THEN BEGIN
      InsertDatLinkToDB(fileid,$28);
      InsertDatLinkToDB(fileid,$34);
      InsertDatLinkToDB(fileid,$54);
      InsertDatLinkToDB(fileid,$58);
      InsertDatLinkToDB(fileid,$5C);
      InsertDatLinkToDB(fileid,$60);
      InsertDatLinkToDB(fileid,$6FC);
      InsertDatLinkToDB(fileid,$700);
    END ELSE BEGIN
    END;
  END;
PROCEDURE OPGE(fileid:LongWord; dir_dat2db:Boolean);
  BEGIN
    IF dir_dat2db THEN BEGIN
      InsertDatLinkToDB(fileid,$1C);
    END ELSE BEGIN
    END;
  END;
PROCEDURE PSPC(fileid:LongWord; dir_dat2db:Boolean);
  BEGIN
    IF dir_dat2db THEN BEGIN
      InsertDatLinkToDB(fileid,$50);
    END ELSE BEGIN
    END;
  END;
PROCEDURE PSPL(fileid:LongWord; dir_dat2db:Boolean);
  VAR
    packages:LongWord;
    i:LongWord;
  BEGIN
    IF dir_dat2db THEN BEGIN
      OniDataConnection.LoadDatFilePart(fileid,$1C,4,@packages);
      IF packages>0 THEN
        FOR i:=0 TO packages-1 DO InsertDatLinkToDB(fileid,$24+i*8);
    END ELSE BEGIN
    END;
  END;
PROCEDURE PSUI(fileid:LongWord; dir_dat2db:Boolean);
  VAR
    i:LongWord;
  BEGIN
    IF dir_dat2db THEN BEGIN
      FOR i:=0 TO 43 DO InsertDatLinkToDB(fileid,$08+i*4);
    END ELSE BEGIN
    END;
  END;
PROCEDURE STNA(fileid:LongWord; dir_dat2db:Boolean);
  VAR
    packages:Word;
    i:LongWord;
  BEGIN
    IF dir_dat2db THEN BEGIN
      OniDataConnection.LoadDatFilePart(fileid,$1E,2,@packages);
      IF packages>0 THEN
        FOR i:=0 TO packages-1 DO InsertDatLinkToDB(fileid,$20+i*4);
    END ELSE BEGIN
    END;
  END;
PROCEDURE TRAC(fileid:LongWord; dir_dat2db:Boolean);
  VAR
    packages:Word;
    i:LongWord;
  BEGIN
    IF dir_dat2db THEN BEGIN
      InsertDatLinkToDB(fileid,$18);
      OniDataConnection.LoadDatFilePart(fileid,$1E,2,@packages);
      IF packages>0 THEN
        FOR i:=0 TO packages-1 DO InsertDatLinkToDB(fileid,$20+i*12+8);
    END ELSE BEGIN
    END;
  END;
PROCEDURE TRAM(fileid:LongWord; dir_dat2db:Boolean);
  BEGIN
    IF dir_dat2db THEN BEGIN
      InsertDatLinkToDB(fileid,$40);
      InsertDatLinkToDB(fileid,$44);
    END ELSE BEGIN
    END;
  END;
PROCEDURE TRAS(fileid:LongWord; dir_dat2db:Boolean);
  BEGIN
    IF dir_dat2db THEN BEGIN
      InsertDatLinkToDB(fileid,$08);
    END ELSE BEGIN
    END;
  END;
PROCEDURE TRBS(fileid:LongWord; dir_dat2db:Boolean);
  VAR
    i:LongWord;
  BEGIN
    IF dir_dat2db THEN BEGIN
      FOR i:=0 TO 4 DO InsertDatLinkToDB(fileid,$08+i*4);
    END ELSE BEGIN
    END;
  END;
PROCEDURE TRCM(fileid:LongWord; dir_dat2db:Boolean);
  VAR
    i:LongWord;
  BEGIN
    IF dir_dat2db THEN BEGIN
      FOR i:=0 TO 2 DO InsertDatLinkToDB(fileid,$5C+i*4);
    END ELSE BEGIN
    END;
  END;
PROCEDURE TRGA(fileid:LongWord; dir_dat2db:Boolean);
  VAR
    i:LongWord;
    packages:Word;
  BEGIN
    IF dir_dat2db THEN BEGIN
      OniDataConnection.LoadDatFilePart(fileid,$1E,2,@packages);
      IF packages>0 THEN
        FOR i:=0 TO packages-1 DO InsertDatLinkToDB(fileid,$20+i*4);
    END ELSE BEGIN
    END;
  END;
PROCEDURE TRGE(fileid:LongWord; dir_dat2db:Boolean);
  BEGIN
    IF dir_dat2db THEN BEGIN
      InsertDatLinkToDB(fileid,$20);
    END ELSE BEGIN
    END;
  END;
PROCEDURE TRIG(fileid:LongWord; dir_dat2db:Boolean);
  BEGIN
    IF dir_dat2db THEN BEGIN
      InsertDatLinkToDB(fileid,$18);
      InsertDatLinkToDB(fileid,$24);
      InsertDatLinkToDB(fileid,$28);
    END ELSE BEGIN
    END;
  END;
PROCEDURE TRMA(fileid:LongWord; dir_dat2db:Boolean);
  VAR
    i:LongWord;
    packages:Word;
  BEGIN
    IF dir_dat2db THEN BEGIN
      OniDataConnection.LoadDatFilePart(fileid,$1E,2,@packages);
      IF packages>0 THEN
        FOR i:=0 TO packages-1 DO InsertDatLinkToDB(fileid,$20+i*4);
    END ELSE BEGIN
    END;
  END;
PROCEDURE TRSC(fileid:LongWord; dir_dat2db:Boolean);
  VAR
    i:LongWord;
    packages:Word;
  BEGIN
    IF dir_dat2db THEN BEGIN
      OniDataConnection.LoadDatFilePart(fileid,$1E,2,@packages);
      IF packages>0 THEN
        FOR i:=0 TO packages-1 DO InsertDatLinkToDB(fileid,$20+i*4);
    END ELSE BEGIN
    END;
  END;
PROCEDURE TSFF(fileid:LongWord; dir_dat2db:Boolean);
  VAR
    i:LongWord;
    packages:LongWord;
  BEGIN
    IF dir_dat2db THEN BEGIN
      OniDataConnection.LoadDatFilePart(fileid,$1C,4,@packages);
      IF packages>0 THEN
        FOR i:=0 TO packages-1 DO InsertDatLinkToDB(fileid,$20+i*4);
    END ELSE BEGIN
    END;
  END;
PROCEDURE TSFT(fileid:LongWord; dir_dat2db:Boolean);
  BEGIN
    IF dir_dat2db THEN BEGIN
      InsertDatLinkToDB(fileid,$1C);
    END ELSE BEGIN
    END;
  END;
PROCEDURE TURR(fileid:LongWord; dir_dat2db:Boolean);
  BEGIN
    IF dir_dat2db THEN BEGIN
      InsertDatLinkToDB(fileid,$60);
      InsertDatLinkToDB(fileid,$6C);
      InsertDatLinkToDB(fileid,$74);
    END ELSE BEGIN
    END;
  END;
PROCEDURE TXAN(fileid:LongWord; dir_dat2db:Boolean);
  VAR
    i:LongWord;
    packages:LongWord;
  BEGIN
    IF dir_dat2db THEN BEGIN
      OniDataConnection.LoadDatFilePart(fileid,$1C,4,@packages);
      IF packages>0 THEN
        FOR i:=0 TO packages-1 DO InsertDatLinkToDB(fileid,$20+i*4);
    END ELSE BEGIN
    END;
  END;
PROCEDURE TXMA(fileid:LongWord; dir_dat2db:Boolean);
  VAR
    i:LongWord;
    packages:LongWord;
  BEGIN
    IF dir_dat2db THEN BEGIN
      OniDataConnection.LoadDatFilePart(fileid,$1C,4,@packages);
      IF packages>0 THEN
        FOR i:=0 TO packages-1 DO InsertDatLinkToDB(fileid,$20+i*4);
    END ELSE BEGIN
    END;
  END;
PROCEDURE TXMB(fileid:LongWord; dir_dat2db:Boolean);
  VAR
    i:LongWord;
    packages:LongWord;
  BEGIN
    IF dir_dat2db THEN BEGIN
      OniDataConnection.LoadDatFilePart(fileid,$1C,4,@packages);
      IF packages>0 THEN
        FOR i:=0 TO packages-1 DO InsertDatLinkToDB(fileid,$20+i*4);
    END ELSE BEGIN
    END;
  END;
PROCEDURE TXMP(fileid:LongWord; dir_dat2db:Boolean);
  BEGIN
    IF dir_dat2db THEN BEGIN
      InsertDatLinkToDB(fileid,$94);
      InsertDatLinkToDB(fileid,$98);
    END ELSE BEGIN
    END;
  END;
PROCEDURE TXTC(fileid:LongWord; dir_dat2db:Boolean);
  BEGIN
    IF dir_dat2db THEN BEGIN
      InsertDatLinkToDB(fileid,$08);
    END ELSE BEGIN
    END;
  END;
PROCEDURE WMCL(fileid:LongWord; dir_dat2db:Boolean);
  BEGIN
    IF dir_dat2db THEN BEGIN
      InsertDatLinkToDB(fileid,$24);
    END ELSE BEGIN
    END;
  END;
PROCEDURE WMMB(fileid:LongWord; dir_dat2db:Boolean);
  VAR
    i:LongWord;
    packages:LongWord;
  BEGIN
    IF dir_dat2db THEN BEGIN
      OniDataConnection.LoadDatFilePart(fileid,$1C,4,@packages);
      IF packages>0 THEN
        FOR i:=0 TO packages-1 DO InsertDatLinkToDB(fileid,$20+i*4);
    END ELSE BEGIN
    END;
  END;
PROCEDURE WPGE(fileid:LongWord; dir_dat2db:Boolean);
  BEGIN
    IF dir_dat2db THEN BEGIN
      InsertDatLinkToDB(fileid,$08);
      InsertDatLinkToDB(fileid,$0C);
    END ELSE BEGIN
    END;
  END;

PROCEDURE InsertHandler(ext:String; needed:Boolean; handler:THandler);
  BEGIN
    SetLength(ConvertHandlers,Length(ConvertHandlers)+1);
    ConvertHandlers[High(ConvertHandlers)].Ext:=ext;
    ConvertHandlers[High(ConvertHandlers)].needed:=needed;
    ConvertHandlers[High(ConvertHandlers)].handler:=handler;
  END;

BEGIN
  InsertHandler('ABNA',False,NIL);
//  InsertHandler('AGDB',True,AGDB);
  InsertHandler('AGDB',False,NIL);
  InsertHandler('AGQC',False,NIL);
  InsertHandler('AGQG',False,NIL);
  InsertHandler('AGQR',False,NIL);
  InsertHandler('AISA',False,NIL);
  InsertHandler('AITR',False,NIL);
  InsertHandler('AKAA',False,NIL);
  InsertHandler('AKBA',False,NIL);
  InsertHandler('AKBP',False,NIL);
  InsertHandler('AKDA',False,NIL);
  InsertHandler('AKEV',True,AKEV);
  InsertHandler('AKOT',True,AKOT);
  InsertHandler('AKVA',False,NIL);
  InsertHandler('BINA',False,NIL);
  InsertHandler('CBPI',True,CBPI);
  InsertHandler('CBPM',True,CBPM);
  InsertHandler('CONS',True,CONS);
  InsertHandler('CRSA',True,CRSA);
  InsertHandler('DOOR',True,DOOR);
  InsertHandler('DPGE',True,DPGE);
  InsertHandler('ENVP',False,NIL);
  InsertHandler('FILM',False,NIL);
  InsertHandler('HPGE',True,HPGE);
  InsertHandler('IDXA',False,NIL);
  InsertHandler('IGHH',True,IGHH);
  InsertHandler('IGPA',True,IGPA);
  InsertHandler('IGPG',True,IGPG);
  InsertHandler('IGSA',True,IGSA);
  InsertHandler('IMPT',True,IMPT);
  InsertHandler('IPGE',True,IPGE);
  InsertHandler('KEYI',True,KEYI);
  InsertHandler('M3GA',True,M3GA);
  InsertHandler('M3GM',True,M3GM);
  InsertHandler('MTRL',True,MTRL);
  InsertHandler('OBAN',False,NIL);
  InsertHandler('OBDC',False,NIL);
  InsertHandler('OBOA',True,OBOA);
  InsertHandler('OFGA',True,OFGA);
  InsertHandler('ONCC',True,ONCC);
  InsertHandler('ONCP',False,NIL);
  InsertHandler('ONCV',True,ONCV);
  InsertHandler('ONFA',False,NIL);
  InsertHandler('ONGS',False,NIL);
  InsertHandler('ONIA',False,NIL);
  InsertHandler('ONLD',False,NIL);
  InsertHandler('ONLV',True,ONLV);
  InsertHandler('ONMA',False,NIL);
  InsertHandler('ONOA',True,ONOA);
  InsertHandler('ONSA',False,NIL);
  InsertHandler('ONSK',True,ONSK);
  InsertHandler('ONTA',False,NIL);
  InsertHandler('ONVL',True,ONVL);
  InsertHandler('ONWC',True,ONWC);
  InsertHandler('OPGE',True,OPGE);
  InsertHandler('OSBD',False,NIL);
  InsertHandler('OTIT',False,NIL);
  InsertHandler('OTLF',False,NIL);
  InsertHandler('PLEA',False,NIL);
  InsertHandler('PNTA',False,NIL);
  InsertHandler('PSPC',True,PSPC);
  InsertHandler('PSPL',True,PSPL);
  InsertHandler('PSUI',True,PSUI);
  InsertHandler('QTNA',False,NIL);
  InsertHandler('SNDD',False,NIL);
  InsertHandler('STNA',True,STNA);
  InsertHandler('SUBT',False,NIL);
  InsertHandler('TRAC',True,TRAC);
  InsertHandler('TRAM',True,TRAM);
  InsertHandler('TRAS',True,TRAS);
  InsertHandler('TRBS',True,TRBS);
  InsertHandler('TRCM',True,TRCM);
  InsertHandler('TRGA',True,TRGA);
  InsertHandler('TRGE',True,TRGE);
  InsertHandler('TRIA',False,NIL);
  InsertHandler('TRIG',True,TRIG);
  InsertHandler('TRMA',True,TRMA);
  InsertHandler('TRSC',True,TRSC);
  InsertHandler('TRTA',False,NIL);
  InsertHandler('TSFF',True,TSFF);
  InsertHandler('TSFL',False,NIL);
  InsertHandler('TSFT',True,TSFT);
  InsertHandler('TSGA',False,NIL);
  InsertHandler('TSTR',False,NIL);
  InsertHandler('TURR',True,TURR);
  InsertHandler('TXAN',True,TXAN);
  InsertHandler('TXCA',False,NIL);
  InsertHandler('TXMA',True,TXMA);
  InsertHandler('TXMB',True,TXMB);
  InsertHandler('TXMP',True,TXMP);
  InsertHandler('TXTC',True,TXTC);
  InsertHandler('VCRA',False,NIL);
  InsertHandler('WMCL',True,WMCL);
  InsertHandler('WMDD',False,NIL);
  InsertHandler('WMM_',False,NIL);
  InsertHandler('WMMB',True,WMMB);
  InsertHandler('WPGE',True,WPGE);   
END.
