#ifndef UTILXMLTOOLS_H
#define UTILXMLTOOLS_H

// Utilities functions specific used for Xml Tools (not general functions)

#include "util.h"
#include "xmlfilter.h"
#include "libs/pugixml.hpp"

namespace UtilXmlTools{

QStringList getAllXmlFilesByWildcard(const QString &wildcard);
QStringList getAllPatchFilesByWildcard(const QString &wildcard);
void backupFile(const QString &file);
void getAllNamedElements(pugi::xml_node &node, QList<pugi::xml_node> &result, XmlFilter &filters);
void displaySuccessMessage(const int numberOperations, const QString &operation);
void displayErrorMessage(const QString& operation, const QString &message, bool exitProgram=true);
pugi::xml_node getFirstNamedElements(pugi::xml_node &node, XmlFilter &filters);

//// inline functions

inline void loadXmlFile(const QString &file, pugi::xml_document &document, pugi::xml_node &rootNode, bool backupsEnabled, const QString &operationForErrorMessage){

    pugi::xml_parse_result result = document.load_file(file.toLatin1().constData());
    rootNode=document.root();

    if(result.status==pugi::status_ok){
        std::cout << "File '" << file.toLatin1().constData() << "' loaded with sucess." << std::endl;
    }
    else{
        UtilXmlTools::displayErrorMessage(operationForErrorMessage,"An error ocurred while loading '" +file + "' XML file\n" + result.description());
    }

    if(backupsEnabled){
        UtilXmlTools::backupFile(file); // bake a backup of the file.
    }

}

inline void saveXmlFile(const QString &file, pugi::xml_document &document, const QString &operationForErrorMessage){
    if(!document.save_file(file.toLatin1().constData(), "\t", pugi::format_indent | pugi::format_save_file_text | pugi::format_no_escapes)){ // output as the system new lines ending
        UtilXmlTools::displayErrorMessage(operationForErrorMessage,"An error ocurred while saving '" + file + "' XML file");
    }
}

//inline void checkIfValidXmlFile(const QString &file){
//    if(!file.endsWith(".xml",Qt::CaseInsensitive)){
//        std::cout << "Tried to load a non xml file: '" << Util::toCstr(file) << "'. XmlTools only work over XmlFiles." << std::endl;
//        exit(1);
//    }
//}

}

#endif // UTILXMLTOOLS_H
