#include "utilxmltools.h"

namespace UtilXmlTools{

QStringList getAllXmlFilesByWildcard(const QString &wildcard){
    QStringList validFilesMatching;
    QStringList filesMatching;

    // Get all files matching the wildcard

    filesMatching=Util::getAllFilesByWildcard(wildcard);

    // Check if all are XmlFiles, only return valid XmlFiles

    for(int i=0; i<filesMatching.size(); i++){
        if(filesMatching[i].endsWith(".xml",Qt::CaseInsensitive)){
            validFilesMatching << filesMatching[i];
        }
    }

    return validFilesMatching;

}

QStringList getAllPatchFilesByWildcard(const QString &wildcard){
    QStringList validFilesMatching;
    QStringList filesMatching;

    // Get all files matching the wildcard

    filesMatching=Util::getAllFilesByWildcard(wildcard);

    // Check if all are PatchFiles, only return valid PatchFiles

    for(int i=0; i<filesMatching.size(); i++){
        if(filesMatching[i].endsWith(".patch",Qt::CaseInsensitive) || filesMatching[i].endsWith(".oni-patch",Qt::CaseInsensitive)){
            validFilesMatching << filesMatching[i];
        }
    }

    return validFilesMatching;

}

void backupFile(const QString &file){
    if(!QFile::exists(file+".bak")){
        if(!Util::backupFile(file)){
            std::cerr << "Couldn't backup file '" << file.toLatin1().constData() << "'. Aborting." << std::endl;
            exit(1);
        }
    }
    else{
        std::cout << "Backup file '" << file.toLatin1().constData() << "'' already exists. Skipping..." << std::endl;
    }
}

void getAllNamedElements(pugi::xml_node &node, QList<pugi::xml_node> &result, XmlFilter &filters){
    for (pugi::xml_node_iterator currNode = node.begin(); currNode != node.end(); ++currNode)
    {

        if ((*currNode).name() == filters.getElementName() && (filters.getParentElementName() == "" || filters.getParentElementName() == (*currNode).parent().name())
                && (filters.getAttributeName() == "" ||
                    Util::toQString((*currNode).attribute(filters.getAttributeName().toLatin1().constData()).value()) == filters.getAttributeValue()) ){ // Seems node attribute must be converted to qtsring to remove \r\n needs to check in future!

            result << *currNode;
            continue;
        }
        getAllNamedElements(*currNode,result,filters);
    }
}

pugi::xml_node getFirstNamedElements(pugi::xml_node &node, XmlFilter &filters){

    pugi::xml_node foundNode;

    for (pugi::xml_node_iterator currNode = node.begin(); currNode != node.end(); ++currNode)
    {
        if ((*currNode).name() == filters.getElementName() && (filters.getParentElementName() == "" || filters.getParentElementName() == (*currNode).parent().name())
                && (filters.getAttributeName() == "" ||
                    Util::toQString((*currNode).attribute(filters.getAttributeName().toLatin1().constData()).value()) == filters.getAttributeValue()) ){
            return *currNode;
        }

        foundNode=getFirstNamedElements(*currNode,filters);

        if(foundNode.type()!=pugi::node_null){
            return foundNode;
        }

    }

    return foundNode;
}

void displaySuccessMessage(const int numberOperations, const QString &operation){
    std::cout << "------------------------------------------------------------------------" << std::endl;
    std::cout << numberOperations << " " << operation.toLatin1().constData() << " operation(s) completed with success!" << std::endl;
    std::cout << "------------------------------------------------------------------------" << std::endl;
}

void displayErrorMessage(const QString& operation, const QString &message, bool exitProgram){
    std::cerr << "************************************************************************" << std::endl;
    std::cerr << operation.toLatin1().constData() << " operation failed!" << std::endl << std::endl;
    std::cerr << message.toLatin1().constData() << std::endl << std::endl;
    if(exitProgram) std::cerr << "Aborting..." << std::endl;
    std::cerr << "************************************************************************" << std::endl;
    if(exitProgram) exit(1);
}

}
