package net.oni2.aeinstaller.backend.oni;

import java.io.File;
import java.io.IOException;
import java.util.Vector;

import net.oni2.aeinstaller.backend.CaseInsensitiveFile;
import net.oni2.aeinstaller.backend.Paths;
import net.oni2.platformtools.PlatformInformation;
import net.oni2.platformtools.applicationinvoker.ApplicationInvoker;
import net.oni2.platformtools.applicationinvoker.ApplicationInvocationResult;
import net.oni2.platformtools.applicationinvoker.EExeType;
import net.oni2.platformtools.applicationinvoker.ERuntimeNotInstalledException;

/**
 * @author Christian Illy
 */
public class XMLTools {

	/**
	 * Patch the XML files in the path with the patches in the other path
	 * 
	 * @param folderWithPatches
	 *            Path containing patches to apply
	 * @param folderWithXml
	 *            Path containing XML files to patch
	 * 
	 * @return XMLTools output
	 */
	public static ApplicationInvocationResult patch(File folderWithPatches,
			File folderWithXml) {
		Vector<String> params = new Vector<String>();
		// xmlTools.exe --patch-files PATCH --force-target-files TOPATCH
		params.add("--patch-files "
				+ new File(folderWithPatches, "*.oni-patch").getPath());
		params.add("--use-patch-filename " + folderWithXml.getPath());
		ApplicationInvocationResult res = null;
		try {
			res = ApplicationInvoker.executeAndWait(EExeType.OSBINARY, null,
					getProgramFile(), params, false);
		} catch (IOException e) {
			e.printStackTrace();
		} catch (ERuntimeNotInstalledException e) {
			e.printStackTrace();
		}
		return res;
	}

	private static File getProgramFile() {
		File toolsPath = CaseInsensitiveFile.getCaseInsensitiveFile(
				Paths.getEditionBasePath(), "Tools");
		File xmlToolsPath = CaseInsensitiveFile.getCaseInsensitiveFile(
				toolsPath, "XmlTools");
		switch (PlatformInformation.getPlatform()) {
			case WIN:
				return CaseInsensitiveFile.getCaseInsensitiveFile(xmlToolsPath,
						"XmlTools.exe");
			case LINUX:
			case MACOS:
				return CaseInsensitiveFile.getCaseInsensitiveFile(xmlToolsPath,
						"XmlTools");
			default:
		}
		return null;
	}
}
