#ifndef XMLPATCH_H
#define XMLPATCH_H

#include "xmltools.h"
#include "optionsparser.h"
#include <omp.h> // OpenMP support

class XmlPatch
{
public:
    XmlPatch(QString patchFilesWildcard, QString forceTargetFilesWildcard, bool noBackups, bool noVerbose);
    void readAndProcessPatchFile();
private:
    QStringList patchFilesToProcess;
    QString forceTargetFilesWildcard;
    pugi::xml_document document;
    pugi::xml_node rootNode;
    bool backupsEnabled, verboseEnabled;
    QString getPatchParameterValue(const QString& line, QString parameter);
    void insertNodesOperation(const QString &xmlString, XmlFilter &filters, const QString &xPathExpression, const QString &filesWildcard="");
    void removeNodesOperation(XmlFilter &filters, const QString &xPathExpression, const QString &filesWildcard="");
    void executeCommandOperation(const QString &commandString);
    void executeCustomCommandOperation(const QString &jsString, const QString &filesWildcard="");
    void checkPatchVersion(const QString &file, QTextStream &fileStream);
    void checkAndProcessValidCommands(QTextStream &fileStream);
#ifdef _USE_OLD_JS_ENGINE
    void displayJsException(QScriptEngine &engine, QScriptValue &engineResult);
#else
    void checkForJsException(QJSValue &engineResult);
#endif
};

#endif // XMLPATCH_H
