unit DataAccess;
interface

uses TypeDefs, Classes, StrUtils, SysUtils;
//uses Data, Classes, SysUtils, StrUtils,
//  Dialogs, ABSDecUtil, ABSMain, DB, Windows;


type
  TDataAccess = class
  private
    FConnectionID:  Integer;
    FFileName:      String;
    FBackend:       TDataBackend;
    FDataOS:        TDataOS;
    FLevelNumber:   Integer;
    FChangeRights:  TChangeRights;
    procedure SetDataOS(DataOS: TDataOS);
  protected
  public
    property ConnectionID: Integer      read FConnectionID;
    property FileName:     String       read FFileName;
    property Backend:      TDataBackend read FBackend;
    property DataOS:       TDataOS      read FDataOS write SetDataOS;
    property LevelNumber:  Integer      read FLevelNumber;

    constructor Create(FileName: String; ConnectionID: Integer; var Msg: TStatusMessages); virtual; abstract;
    procedure Close; virtual; abstract;

    function ExtractFileIDOfName(Name: String): Integer; virtual;
    function GetFileInfo(FileID: Integer): TFileInfo; virtual;
    function GetFileInfoByName(Name: String): TFileInfo; virtual;
    function GetFilesList(Ext: String; Pattern: String;
      NoEmptyFiles: Boolean; SortType: TSortType): TStrings; virtual; abstract;
    function GetFileCount: Integer; virtual; abstract;
    function GetExtensionsList(ExtListFormat: TExtensionFormat): TStrings; virtual; abstract;

    procedure LoadDatFile(FileID: Integer; var Target: TStream); overload; virtual; abstract;
    procedure LoadDatFile(FileID: Integer; var Target: TByteData); overload; virtual; abstract;
    procedure UpdateDatFile(FileID: Integer; Src: TStream); overload; virtual; abstract;
    procedure UpdateDatFile(FileID: Integer; Src: TByteData); overload; virtual; abstract;
    procedure LoadDatFilePart(FileID, Offset, Size: Integer; var Target: TStream); overload; virtual; abstract;
    procedure LoadDatFilePart(FileID, Offset, Size: Integer; var Target: TByteData); overload; virtual; abstract;
    procedure LoadDatFilePart(FileID, Offset, Size: Integer; Target: Pointer); overload; virtual; abstract;
    procedure UpdateDatFilePart(FileID, Offset, Size: Integer; Src: TStream); overload; virtual; abstract;
    procedure UpdateDatFilePart(FileID, Offset, Size: Integer; Src: TByteData); overload; virtual; abstract;
    procedure UpdateDatFilePart(FileID, Offset, Size: Integer; Src: Pointer); overload; virtual; abstract;

    function GetRawList(FileID: Integer): TRawDataList; virtual; abstract;
    function GetRawInfo(FileID, DatOffset: Integer): TRawDataInfo;

    procedure LoadRawFile(FileID, DatOffset: Integer; var Target: TStream); overload; virtual; abstract;
    procedure LoadRawFile(FileID, DatOffset: Integer; var Target: TByteData); overload; virtual; abstract;
    procedure UpdateRawFile(FileID, DatOffset, Size: Integer; Src: TStream); overload; virtual; abstract;
    procedure UpdateRawFile(FileID, DatOffset, Size: Integer; Src: TByteData); overload; virtual; abstract;
    procedure LoadRawFilePart(FileID, DatOffset, Offset, Size: Integer; var Target: TStream); overload; virtual; abstract;
    procedure LoadRawFilePart(FileID, DatOffset, Offset, Size: Integer; var Target: TByteData); overload; virtual; abstract;
    procedure LoadRawFilePart(FileID, DatOffset, Offset, Size: Integer; Target: Pointer); overload; virtual; abstract;
    procedure UpdateRawFilePart(FileID, DatOffset, Offset, Size: Integer; Src: TStream); overload; virtual; abstract;
    procedure UpdateRawFilePart(FileID, DatOffset, Offset, Size: Integer; Src: TByteData); overload; virtual; abstract;
    procedure UpdateRawFilePart(FileID, DatOffset, Offset, Size: Integer; Src: Pointer); overload; virtual; abstract;

    function AppendRawFile(LocSep: Boolean; Size: Integer; Src: TStream): Integer; overload; virtual; abstract;
    function AppendRawFile(LocSep: Boolean; Size: Integer; Src: TByteData): Integer; overload; virtual; abstract;
    function AppendRawFile(LocSep: Boolean; Size: Integer; Src: Pointer): Integer; overload; virtual; abstract;
  published
  end;



implementation


(*
 Implementation of TDataAccess
*)

function TDataAccess.ExtractFileIDOfName(Name: String): Integer;
begin
  if Name[5] = '-' then
    Result := StrToInt(MidStr(Name, 1, 4))
  else
    Result := StrToInt(MidStr(Name, 1, 5));
end;


function TDataAccess.GetFileInfo(FileID: Integer): TFileInfo;
begin
  Result.ID := -1;
  Result.Name := '';
  Result.Extension := '';
  Result.Size := -1;
  Result.FileType := 0;
  Result.DatAddr := -1;
end;


function TDataAccess.GetFileInfoByName(Name: String): TFileInfo;
var
  i:     Integer;
  files: TStrings;
begin
  Result := GetFileInfo(-1);
  files  := GetFilesList('', Name, False, ST_IDAsc);
  if files.Count = 0 then
  else
  begin
    for i := 0 to files.Count - 1 do
    begin
      if MidStr(files.Strings[i], Pos('-', files.Strings[i]) + 1,
            Length(files.Strings[i]) - Pos('-', files.Strings[i]) - 5) = name then
      begin
        Result := GetFileInfo(ExtractFileIDOfName(files.Strings[i]));
        Break;
      end;
    end;
  end;
  files.Free;
end;


function TDataAccess.GetRawInfo(FileID, DatOffset: Integer): TRawDataInfo;
var
  i: LongWord;
  RawList: TRawDataList;
begin
  RawList          := GetRawList(FileID);
  Result.SrcID     := -1;
  Result.SrcOffset := -1;
  Result.RawAddr   := -1;
  Result.RawSize   := -1;
  if Length(RawList) > 0 then
  begin
    for i := 0 to High(RawList) do
    begin
      if RawList[i].SrcOffset = DatOffset then
      begin
        Result.SrcID     := FileID;
        Result.SrcOffset := RawList[i].SrcOffset;
        Result.RawAddr   := RawList[i].RawAddr;
        Result.RawSize   := RawList[i].RawSize;
        Result.LocSep    := RawList[i].LocSep;
        Break;
      end;
    end;
  end;
end;


procedure TDataAccess.SetDataOS(DataOS: TDataOS);
begin
  raise ENotImplemented.Create('TDataAccess.SetDataOS: TBD!');
end;

end.
