#include <windows.h>

#include "../Daodan.h"
#include "../Daodan_BSL.h"
#include "../Daodan_Cheater.h"
#include "../Daodan_Config.h"
#include "../Daodan_GL.h"
#include "../Daodan_Patch.h"
#include "../Daodan_Persistence.h"
#include "../Daodan_Utility.h"
#include "../Daodan_Win32.h"
#include "../flatline/Flatline_BSL.h"
#include "../flatline/Flatline_Hooks.h"
#include "../Oni.h"
#include "objt.h"

typedef int (__cdecl *CHINESEPROC)(DWORD ThreadId); 

// Hooked WMrSlider_SetRange() in ONiOGU_Options_InitDialog. Disables a gamma
// slider in windowed mode.
static void ONICALL DD_ONiOGU_GammaSlider_SetRange(WMtWindow* window, int min_value, int max_value)
{
	WMrWindow_SetEnabled(window, M3gResolutionSwitch && opt_gamma);
	WMrSlider_SetRange(window, min_value, max_value);
}

void ONICALL DD_M3rDraw_BigBitmap(M3tTextureMap_Big* inBigBitmap, const M3tPointScreen* inDestPoint, UUtUns16 inWidth, UUtUns16 inHeight, UUtUns32 inShade, UUtUns16 inAlpha) /* 0 - M3cMaxAlpha */
{
	UUtUns16 x;
	UUtUns16 y;

	UUtUns16 index;
	UUtUns16 remaining_width;
	UUtUns16 remaining_height;

	M3tPointScreen dest_point;
	dest_point.z = inDestPoint->z;
	dest_point.invW = inDestPoint->invW;

	index = 0;
	remaining_height = inHeight;
	dest_point.y = (UUtInt16)((UUtUns16)inDestPoint->y);
	for (y = 0; y < inBigBitmap->num_y; y++)
	{
		remaining_width = inWidth;
		dest_point.x = (UUtInt16)((UUtUns16)inDestPoint->x);
		for (x = 0; x < inBigBitmap->num_x; x++)
		{
			UUtUns16 width;
			UUtUns16 height;
			
			width = 256 < remaining_width ? 256 : remaining_width;
			height = 256 < remaining_height ? 256 : remaining_height;
            			
			M3rDraw_Bitmap(inBigBitmap->textures[index], &dest_point, width, height, inShade, inAlpha);

			dest_point.x += 256;
			remaining_width -= 256;
			index++;
		}
		dest_point.y += 256;
		remaining_height -= 256;
	}
}


void ONICALL DDrShowResumeButton(WMtWindow* window, int visibility)
{
	if (visibility)
		WMrWindow_SetLocation(window, 150, 350);
	WMrWindow_SetVisible(window, visibility);
}


/* Options always visible patch */
void ONICALL DDrShowOptionsButton(WMtWindow* window, int visibility)
{
	WMrWindow_SetVisible(window, 1);
}

void ONICALL DDrGame_Init()
{
	if (opt_usedaodanbsl)
		SLrDaodan_Initialize();
	if (patch_flatline)
		SLrFlatline_Initialize();
}


//this was broken 
FILE** _UUgError_WarningFile = (FILE**)0x005711B4;
FILE* ONICALL DDrPrintWarning(int filename, int linenumber, unsigned __int16 errornum, int message)
{
	FILE *v4; // eax@1
	FILE *result; // eax@4
	char v6[512]; // [sp+0h] [bp-100h]@1
	FILE* UUgError_WarningFile = *_UUgError_WarningFile;

	if (filename && message && (strlen((const char*)filename)+strlen((const char*)message))<420) {
		sprintf(
			v6,
			"Error %x reported from File: %s, Line: %d (message follows) \r\n%s",
			errornum,
			(const char*)filename,
			linenumber,
			(const char*)message);

		if ( UUgError_WarningFile 
			|| (UUgError_WarningFile = oni_fopen("debugger.txt", "wb"), UUgError_WarningFile ) )
		{ 
			oni_fprintf(UUgError_WarningFile, "%s\r\n", v6);
			oni_fflush(UUgError_WarningFile);
		}
	}
	//oni_fprintf(stdout, v6);
	//sprintf(&v6, "%s", message);
	*_UUgError_WarningFile = UUgError_WarningFile;
	result = UUgError_WarningFile;
	return result; 
}

_COrTextArea_Resize Oni_COrTextArea_Resize = (_COrTextArea_Resize)0;
int16_t ONICALL DD_COrTextArea_Resize(void* inTextArea, UUtRect* inBounds, int16_t inNumTextEntries) {
	if (inTextArea == COgCommandLine) {
		inBounds->top -= 10;
	} else if (inTextArea == COgConsoleLines) {
		inBounds->bottom -= 10;
	}
	return Oni_COrTextArea_Resize(inTextArea, inBounds, inNumTextEntries);
}

#define IMcShade_Red (0xFFFF0000)
#define IMcShade_Green (0xFF00FF00)
#define IMcShade_Blue (0xFF0000FF)
void ONICALL DD_OBJiTriggerVolume_Draw(OBJtObject* inObject, uint32_t inDrawFlags)
{
	UUtUns32				itr;
	OBJtOSD_All				*inOSD = (OBJtOSD_All *) inObject->object_data;
	OBJtOSD_TriggerVolume	*trigger_osd = &inOSD->osd.trigger_volume_osd;
	M3tPoint3D				*points = trigger_osd->volume.worldPoints;
	UUtUns32				shade = 0xFFFFFF;

	if (!OBJgTriggerVolume_Visible) {
		return;
	}

	if (OBJrTriggerVolume_IntersectsCharacter(inObject, trigger_osd->team_mask, ONgGameState->PlayerCharacter)) {
		shade = IMcShade_Red;
	}
	else
	{
		shade = IMcShade_Blue;
	}

	M3rGeom_Line_Light(points + 0, points + 1, shade);
	M3rGeom_Line_Light(points + 1, points + 3, shade);
	M3rGeom_Line_Light(points + 3, points + 2, shade);
	M3rGeom_Line_Light(points + 2, points + 0, shade);

	M3rGeom_Line_Light(points + 4, points + 5, shade);
	M3rGeom_Line_Light(points + 5, points + 7, shade);
	M3rGeom_Line_Light(points + 7, points + 6, shade);
	M3rGeom_Line_Light(points + 6, points + 4, shade);

	M3rGeom_Line_Light(points + 0, points + 4, shade);
	M3rGeom_Line_Light(points + 1, points + 5, shade);
	M3rGeom_Line_Light(points + 3, points + 7, shade);
	M3rGeom_Line_Light(points + 2, points + 6, shade);
}

_ONrMechanics_Register Oni_ONrMechanics_Register = (_ONrMechanics_Register)0;
int16_t ONICALL DD_ONrMechanics_Register(uint32_t inObjectType, uint32_t inObjectTypeIndex, char* inGroupName,
	uint32_t inSizeInMemory, OBJtMethods* inObjectMethods, uint32_t inFlags, void* inMechanicsMethods)
{
	if (strcmp("Trigger Volume", inGroupName) == 0) {
		inObjectMethods->rDraw = DD_OBJiTriggerVolume_Draw;
	}
	return Oni_ONrMechanics_Register(inObjectType, inObjectTypeIndex, inGroupName, inSizeInMemory, inObjectMethods, inFlags, inMechanicsMethods);
}



int DD_Patch_DebugNameTextureInit(short width, short height, int type, int allocated, int flags, char* name, void** output)
{
	//flags = (1 << 10);
	type = 1;
	//DDrPatch_Byte( 0x005EB83C + 3, 0xff );
	DDrPatch_Int32((int*)(OniExe + 0x001EB83C), 0xFF000000 );
	return M3rTextureMap_New(width, height, type, allocated, flags, name, output);
}

short DD_Patch_DebugNameShadeHack( Character* Char )
{
	return TSrContext_SetShade(*(void**)(OniExe + 0x001EB844), ONrCharacter_GetHealthShade( Char->Health, Char->MaxHealth ));
	//return TSrContext_SetShade(*(void**)0x005EB844, 0xFFFFFFFF);
}


// Disable UUrPlatform_Initalize/Terminate, this enables the Alt-Tab and the
// Windows key but has the possible side effect of allowing the screensaver
// to enable itself in-game.
void DD_Patch_AltTab()
{
	// 0xC3 = ret, so makes those functions just have a "ret" instruction at their start
	DDrPatch_Byte  ((char*)UUrPlatform_Initialize, 0xC3);
	DDrPatch_Byte  ((char*)UUrPlatform_Terminate, 0xC3);
}

// Textures using ARGB8888 can be used
void DD_Patch_ARGB8888()
{
	DDrPatch_Byte  ((char*)(OniExe + 0x00135af0), 0x07);
	DDrPatch_Byte  ((char*)(OniExe + 0x00135af4), 0x0B);
}

// Fix BinkBufferInit() call in BKrMovie_Play() to use GDI (DIB) blitting
// instead of DirectDraw; patch ONiRunGame to use the same method to play
// outro (ie., BKrMovie_Play() instead of ONrMovie_Play_Hardware() as the
// latter has problems on WINE).
void DD_Patch_BinkPlay()
{
	// push BINKBUFFERAUTO -> push BINKBUFFERDIBSECTION.
	DDrPatch_Byte((void*)(OniExe + 0x0008829b + 1), 0x02);
	// call ONrMovie_Play_Hardware -> call ONrMovie_Play
	DDrPatch_MakeCall((void*)(OniExe + 0x000d496f), ONrMovie_Play);
}

// Enables d_regen (unfinished) and prevents fly-in portraits from being
// stretched when playing in widescreen resolutions. 
void DD_Patch_BSL()
{
	//Calculating the value of the needed offset is much more reliable when the compiler does it for you.

	//TODO: fix moonshadow.
	Character * Chr = 0;
	int NoPath = (int)&(Chr[0].RegenHax) & 0x000000FF;
	const unsigned char regen_patch[] =
	{0x90, 0x90, 0x90, 0x90, 0x90,				// mov    al, _WPgRegenerationCheat	-> NOOP
	0x90, 0x90,									// test   al, al					-> NOOP
	0x90, 0x90,									// jz	  short loc_51BB98			-> NOOP
	0x8B, 0x86, (char)NoPath, 0x01, 0x00, 0x00, // mov     eax, [esi+Character.field_1E8]
												//	-> mov     eax, [esi+Character.RegenHax]
	0x85, 0xC0,									// test eax, eax
	0x74, 0x21									// jnz 0x21 -> jz 0x21
	};	
	DDrPatch_Const((char*)(OniExe + 0x0011BB64), regen_patch);

	// Patches for existing BSL functions
	SLrDaodan_Patch();
}

// Adds new cheat codes if cheattable is also enabled
void DD_Patch_Cheater()
{
	DDrPatch_MakeCall((void*)(OniExe + 0x000f618f), (void*)DDrCheater);
	DDrPatch_Int16((short*)(OniExe + 0x000deb45), 0x5590);
#if 1
	DDrPatch_MakeCall((void*)(OniExe + 0x000deb47), (void*)FallingFrames);
#endif
	DDrPatch_MakeJump((void*)(OniExe + 0x0010f021), (void*)DDrCheater_LevelLoad);
}

// Cheats always enabled
void DD_Patch_CheatsEnabled()
{
	DDrPatch_MakeJump((void*)ONrPersist_GetWonGame, (void*)DDrPersist_GetWonGame);
}

// Use Daodan's own cheattable
void DD_Patch_CheatTable()
{
	DDrPatch_Int32 ((int*)(OniExe + 0x000f616b), (int)&DDr_CheatTable[0].name);
	DDrPatch_Int32 ((int*)(OniExe + 0x000f617a), (int)&DDr_CheatTable[0].message_on);
}

// Load chinese font DLL if available
void DD_Patch_Chinese()
{
	if (GetFileAttributes("xfhsm_oni.dll") != INVALID_FILE_ATTRIBUTES)
	{
		HMODULE dll;
		DWORD err;

 		DDrStartupMessage("Daodan: Loading chinese DLL");
		dll = LoadLibrary("xfhsm_oni.dll");
		err = GetLastError();
		if( dll )
		{
			void* proc = GetProcAddress( dll, "InstallHook" );
			if(proc)
			{
				((CHINESEPROC)proc)(GetCurrentThreadId());
			}
		} else {
			char msg[100];
			FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, NULL, err, 0, msg, 100, NULL);
			DDrStartupMessage("Daodan: Loading DLL failed with error %i: %s", err, msg);
		}
	}
}

// Limit cursor to Oni's window
void DD_Patch_ClipCursor()
{
	// LIrMode_Set: replace LIrPlatform_Mode_Set call with our hook.
	DDrPatch_MakeCall((void*)(OniExe + 0x00003f9f), (void*) DD_LIrPlatform_Mode_Set);

	// LIrMode_Set_Internal: replace LIrPlatform_Mode_Set call with our hook.
	DDrPatch_MakeCall((void*)(OniExe + 0x00003fff), (void*) DD_LIrPlatform_Mode_Set);
	
	// LIrTermiante: replace LIrPlatform_Terminate call with our hook.
	DDrPatch_MakeCall((void*)(OniExe + 0x000004cb8), (void*) DD_LIrPlatform_Terminate);
}

// Disables weapon cooldown exploit
void DD_Patch_CooldownTimer()
{
	const unsigned char cooldown_patch[] = { 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90 };
	DDrPatch_Const ((char*)(OniExe + 0x0011a825), cooldown_patch);
}

// Daodan device mode enumeration function
void DD_Patch_DaodanDisplayEnum()
{
	DDrPatch_MakeJump((void*)gl_enumerate_valid_display_modes, (void*)DD_GLrEnumerateDisplayModes);
}

// Adds new BSL functions
void DD_Patch_DaodanInit()
{
	DDrPatch_MakeCall((void*)(OniExe + 0x000d345a), (void*)DDrGame_Init);
}

// Forced DirectInput (for Windows NT)
void DD_Patch_DirectInput()
{
	DDrPatch_Byte((char*)(OniExe + 0x00002e6d), 0xeb);
}

// Disable Oni's command line parser so it doesn't interfere with ours
void DD_Patch_DisableCmdLine()
{
	DDrPatch_Int32 ((int*)(OniExe + 0x000d3570), 0xc3c03366);
}

// Enable flatline multiplayer code
void DD_Patch_Flatline()
{
	DDrPatch_MakeCall((void*)(OniExe + 0x000E17F6), FLrHook_Lasers );
	
	//Flatline related stuff
	DDrPatch_MakeCall((void*)(OniExe + 0x000FBCEA), DDrText_Hook);
	
	DDrPatch_Int32((int*)(OniExe + 0x000B24D2), (unsigned int)FLrSpawnHack);

	DDrPatch_NOOP((char*)(OniExe + 0x000C26CB), 6);

	DDrPatch_MakeCall((void*)(OniExe + 0x000C26CB), FLrHook_DoorOpen); 
	DDrPatch_MakeCall((void*)(OniExe + 0x000EE3CF), FLrHook_ConsoleActivate);
}

// Font texture cache doubled
void DD_Patch_FontTextureCache()
{
	DDrPatch_Byte((char*)(OniExe + 0x00020ea7), 0x20);
	DDrPatch_Byte((char*)(OniExe + 0x00020f4a), 0x40);
}

// Disable Oni's internal CLrGetCommandLine function (to eventually replace it with our own)
void DD_Patch_GetCmdLine()
{
	DDrPatch_NOOP  ((char*)(OniExe + 0x000d3280), 51);
}

// Allow HD screens with resolution < 1024*768
void DD_Patch_HDScreens_LowRes()
{
	DDrPatch_MakeJump((void*)M3rDraw_BigBitmap, (void*)DD_M3rDraw_BigBitmap);
}

void DD_Patch_HighresConsole() {
	Oni_COrTextArea_Resize = DDrPatch_MakeDetour((void*)COrTextArea_Resize, (void*)DD_COrTextArea_Resize);
}

// Hackish fix for Konoko not kicking guns
// Don't use this, it breaks stairs.
void DD_Patch_KickGuns()
{
	const unsigned char kickgun_patch[] = { 0x00, 0x05, 0x00, 0x00, 0x00, 0xC7, 0x05, 0x1C, 0xC9, 0x5E, 0x00, 0x70, 0xB8, 0x43, 0x00, 0xC7, 0x05, 0x20, 0xC9, 0x5E, 0x00, 0x20, 0xBE, 0x43 };
	DDrPatch_Const ((char*)(OniExe + 0x000dc420), kickgun_patch);
}

// Disable loading the vtuneapi.dll
void DD_Patch_KillVTune()
{
	DDrPatch_Byte  ((char*)(OniExe + 0x00026340), 0xC3);
}

// Now supports textures up to 512x512
void DD_Patch_LargeTextures()
{
	DDrPatch_Byte  ((char*)(OniExe + 0x00005251), 0x10);
}

// Non-"_Final" levels are now valid
void DD_Patch_LevelPlugins()
{
	DDrPatch_Byte  ((char*)(OniExe + 0x000206a8), 0x01);
}

// Weapon on ground shown with name and magazine contents
void DD_Patch_NewWeap()
{
	//Makes it always say "Received weapon_name."
	//Needs check for loc_4DFC66
	//DDrPatch_NOOP((char*)(OniExe + 0x000E4DF8),2);

	//Adds Weapon name and ammo meter to pickup autoprompt
	DDrPatch_NOOP((char*)(OniExe + 0x000FAC73), 9);
	DDrPatch_NOOP((char*)(OniExe + 0x000FAC80), 5);
	DDrPatch_MakeCall((void*)(OniExe + 0xFAC85), (void*)DDrWeapon2Message);
	
	//Moves location of colors
	//DDrPatch_Int32((int*)(OniExe + 0x0002E3D5), (int)&DDrDSayColors );
	//DDrPatch_Int32((int*)(OniExe + 0x0002E3DA), (int)&DDrDSayColors );
}

// Disable Multi-byte character awareness patch (multiple language support)
void DD_Patch_NoMultiByte()
{
	DDrPatch_Byte  ((char*)(OniExe + 0x0002d8f8), 0xeb);
	DDrPatch_Byte  ((char*)(OniExe + 0x0002d9ad), 0xeb);
	DDrPatch_Byte  ((char*)(OniExe + 0x0002dbe2), 0xeb);
	DDrPatch_Byte  ((char*)(OniExe + 0x0002dec3), 0xeb);
	DDrPatch_Byte  ((char*)(OniExe + 0x0002e2ab), 0xeb);
	DDrPatch_Byte  ((char*)(OniExe + 0x0002e2c4), 0xeb);
	DDrPatch_Byte  ((char*)(OniExe + 0x0002e379), 0xeb);
	DDrPatch_Byte  ((char*)(OniExe + 0x0002e48c), 0xeb);
	DDrPatch_Byte  ((char*)(OniExe + 0x0002e4d0), 0xeb);
	DDrPatch_Byte  ((char*)(OniExe + 0x0002e4f4), 0xeb);
	DDrPatch_Byte  ((char*)(OniExe + 0x0002e646), 0xeb);
	DDrPatch_Byte  ((char*)(OniExe + 0x0002e695), 0xeb);
	DDrPatch_Byte  ((char*)(OniExe + 0x0002e944), 0xeb);
	DDrPatch_Byte  ((char*)(OniExe + 0x0002e95d), 0xeb);
	DDrPatch_Byte  ((char*)(OniExe + 0x0002e98e), 0xeb);
	DDrPatch_Byte  ((char*)(OniExe + 0x0002e9dc), 0xeb);
}

// Fix options not visible in main menu when a game was started
void DD_Patch_OptionsVisible()
{
	DDrPatch_MakeCall((void*)(OniExe + 0x000d2d2d), DDrShowOptionsButton);
	DDrPatch_MakeCall((void*)(OniExe + 0x000d2d43), DDrShowResumeButton);
}

// Unlocks particle action disabling/enabling bits for all events. (Will be
// controlled by a command line switch when I figure out how to do that without
// Win32 hacks.)
void DD_Patch_ParticleDisableBit()
{
	DDrPatch_Int16 ((short*)(OniExe + 0x001b184), 0x9090);
}

// Pathfinding grid cache size x8
void DD_Patch_PathFinding()
{
	const unsigned char pathfinding[2] = {0x90 , 0xE9 };
	DDrPatch_Byte  ((char*)(OniExe + 0x0010b03b), 0x20);
	DDrPatch_Byte  ((char*)(OniExe + 0x0010b04c), 0x20);

	//other stuff
	DDrPatch_Const((char*)(OniExe + 0x00040789), pathfinding);
}

// Projectile awareness fixed
void DD_Patch_ProjAware()
{
	DDrPatch_Byte  ((char*)(OniExe + 0x0009c07c), 0x6c);
	DDrPatch_Byte  ((char*)(OniExe + 0x0009c080), 0x70);
	DDrPatch_Byte  ((char*)(OniExe + 0x0009c084), 0x74);
	DDrPatch_Byte  ((char*)(OniExe + 0x0009c110), 0x6c);
}

// Safe startup message printer
void DD_Patch_SafePrintf()
{
	DDrPatch_MakeJump((void*)UUrStartupMessage, (void*)DDrStartupMessage);
}

// Show all (also enemies') lasersights
void DD_Patch_ShowAllLasersights()
{
	DDrPatch_NOOP((char*)(OniExe + 0x000E1957), 6 );
}

void DD_Patch_ShowTriggerVolumes()
{
	Oni_ONrMechanics_Register = DDrPatch_MakeDetour((void*)ONrMechanics_Register, (void*)DD_ONrMechanics_Register);
}

// Experiment with allowing enemies to be thrown over railings
void DD_Patch_Throwtest()
{
	const unsigned char throwtest_patch[] = { 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90 };
	DDrPatch_Const((char*)(OniExe + 0x000dc190), throwtest_patch);
}

// DaodanGL with windowed mode support
void DD_Patch_UseDaodanGL()
{
	// LIrPlatform_Mode_Set: GetWindowRect -> GetClientRect.
	DDrPatch_NOOP((char*) OniExe + 0x00002dd6, 6);
	DDrPatch_MakeCall((char*) OniExe + 0x00002dd6, (void*) GetClientRect);

	// UUrWindow_GetSize: GetWindowRect -> GetClientRect.
	DDrPatch_NOOP((char*) OniExe + 0x0002651c, 6);
	DDrPatch_MakeCall((char*) OniExe + 0x0002651c, (void*) GetClientRect);

	// LIrPlatform_PollInputForAction: fix GetCursorPos call to return client coordinates.
	DDrPatch_NOOP((char*) OniExe + 0x000032cc, 6);
	DDrPatch_MakeCall((char*) OniExe + 0x000032cc, (void*) DD_GetCursorPos);

	// LIrPlatform_InputEvent_GetMouse: fix GetCursorPos call to return client coordinates.
	DDrPatch_NOOP((char*) OniExe + 0x00002cc2, 6);
	DDrPatch_MakeCall((char*) OniExe + 0x00002cc2, (void*) DD_GetCursorPos);

	// LIrPlatform_PollInputForAction: translate SetCursorPos position to screen coordinates.
	DDrPatch_NOOP((char*) OniExe + 0x000032b7, 6);
	DDrPatch_MakeCall((char*) OniExe + 0x000032b7, (void*) DD_SetCursorPos);

	// LIrPlatform_PollInputForAction: translate SetCursorPos position to screen coordinates.
	DDrPatch_NOOP((char*) OniExe + 0x00003349, 6);
	DDrPatch_MakeCall((char*) OniExe + 0x00003349, (void*) DD_SetCursorPos);

	// Replace ONrPlatformInitialize.
	DDrPatch_MakeJump((void*) ONrPlatform_Initialize, (void*) DD_ONrPlatform_Initialize);

	// Replace gl_platform_initialize.
	DDrPatch_MakeJump((void*) gl_platform_initialize, (void*) DD_GLrPlatform_Initialize);

	// Replace gl_platform_dispose.
	DDrPatch_MakeJump((void *) gl_platform_dispose, (void*) DD_GLrPlatform_Dispose);
}

// Performance patch
void DD_Patch_UseGetTickCount()
{
	DDrPatch_MakeJump((void*)UUrMachineTime_High, (void*)DDrMachineTime_High);
	DDrPatch_MakeJump((void*)UUrMachineTime_High_Frequency, (void*)DDrMachineTime_High_Frequency);
	DDrPatch_MakeJump((void*)UUrMachineTime_Sixtieths, (void*)DDrMachineTime_Sixtieths);
}

// Adds working function for existing BSL command wp_fadetime, sets fade time to 4800
void DD_Patch_WpFadetime()
{
	// Makes wp_fadetime actually have a function
	const unsigned char fadetime_patch[] = { 0x66, 0x8B, 0x1D, 0xC4, 0x7D, 0x62, 0x00, 0x66, 0x89, 0x5E, 0x46, 0x5B, 0x5E, 0x83, 0xC4, 0x14, 0xC3 };
	DDrPatch_Const ((char*)(OniExe + 0x0011a889), fadetime_patch);
	DDrPatch_Byte  ((char*)(OniExe + 0x0011a560), 0x31);
	
	// Sets the fadetime to 4800 by default
	DDrPatch_Int16 ((short*)(OniExe + 0x0011ab0e), 0x12c0);
}

// Disable gamma slider in options in windowed mode
void DD_Patch_GammaSlider()
{
	DDrPatch_MakeCall((void*)(OniExe + 0x000d262c), (void*)DD_ONiOGU_GammaSlider_SetRange);
}

// Fix the warning print method
void DD_Patch_PrintWarning()
{
	DDrPatch_MakeJump((void*)(OniExe + 0x000245A0), (void*)DDrPrintWarning);
}

//Fix crappy ai2_shownames
void DD_Patch_ShowNames()
{
	//Set distance above head to 4.0
	DDrPatch_Int32((int*)(OniExe + 0x0008C998), 0x005296C8);
	//texture height
	DDrPatch_Byte((char*)(OniExe + 0x0008C9DF), 0x3F );
	//texture	width
	DDrPatch_NOOP((char*)(OniExe + 0x0008C9CA), 6 );

/*
// Crashes game.
	//Set the text color to whatever we like ;)
	DDrPatch_NOOP((char*)(OniExe + 0x0008C898), 6 );
	DDrPatch_Byte((char*)(OniExe + 0x0008C898), 0x8B );
	DDrPatch_Byte((char*)(OniExe + 0x0008C899), 0xCE );

	DDrPatch_MakeCall((void*)(OniExe + 0x0008C8A3), DD_Patch_DebugNameShadeHack);
	
	//Make the background black for additive blending
	DDrPatch_MakeCall((void*)(OniExe + 0x0008C802), DD_Patch_DebugNameTextureInit );
*/
}

/*
void DD_Patch_ShowTriggerVolumes()
{
	DDrPatch_Int32((int*)(OniExe + 0x000cc9bb+4), (uint32_t)DD_OBJiTriggerVolume_Draw);
}

void DD_Patch_ShowFlags()
{
	DDrPatch_Int32((int*)(OniExe + 0x000c4ed4+4), (uint32_t)DD_OBJiFlag_Draw);
}
*/

bool DD_Patch_Init()
{
	DDrStartupMessage("Daodan: Patching engine");
	
	if (patch_alttab)
		DD_Patch_AltTab();
	
	if (patch_argb8888)
		DD_Patch_ARGB8888();

	if (patch_binkplay)
		DD_Patch_BinkPlay();

	if (patch_bsl)
		DD_Patch_BSL();

	if (patch_cheater)
		DD_Patch_Cheater();

	if (patch_cheatsenabled)
		DD_Patch_CheatsEnabled();

	if (patch_cheattable)
		DD_Patch_CheatTable();
	
	if (patch_chinese)
		DD_Patch_Chinese();

	if (patch_clipcursor)
		DD_Patch_ClipCursor();

	if (patch_cooldowntimer)
		DD_Patch_CooldownTimer();

	if (patch_daodandisplayenum)
		DD_Patch_DaodanDisplayEnum();
	
	if (patch_directinput)
		DD_Patch_DirectInput();

	if (patch_disablecmdline)
		DD_Patch_DisableCmdLine();

	if (patch_fonttexturecache)
		DD_Patch_FontTextureCache();

	if (patch_getcmdline)
		DD_Patch_GetCmdLine();

	if (patch_hdscreens_lowres)
		DD_Patch_HDScreens_LowRes();

	if (patch_highres_console)
		DD_Patch_HighresConsole();
	
	if (patch_kickguns)
		DD_Patch_KickGuns();
	
	//if (patch_killvtune)
	//	DD_Patch_KillVTune();

	if (patch_largetextures)
		DD_Patch_LargeTextures();
	
	if (patch_levelplugins)
		DD_Patch_LevelPlugins();

	if (patch_newweapon)
		DD_Patch_NewWeap();

	if (patch_nomultibyte)
		DD_Patch_NoMultiByte();

	if(patch_optionsvisible)
		DD_Patch_OptionsVisible();

	if (patch_particledisablebit)
		DD_Patch_ParticleDisableBit();
	
	if (patch_pathfinding)
		DD_Patch_PathFinding();

	if (patch_projaware)
		DD_Patch_ProjAware();

	if (patch_safeprintf)
		DD_Patch_SafePrintf();

	if (patch_showalllasersights)
		DD_Patch_ShowAllLasersights();

	if (patch_showtriggervolumes)
		DD_Patch_ShowTriggerVolumes();
	
	if (patch_throwtest)
		DD_Patch_Throwtest();

	if (patch_usedaodangl)
		DD_Patch_UseDaodanGL();

	if (patch_usegettickcount)
		DD_Patch_UseGetTickCount();
	
	if (patch_wpfadetime)
		DD_Patch_WpFadetime();


	DD_Patch_DaodanInit();
	
	DD_Patch_GammaSlider();

	DD_Patch_PrintWarning();


	DD_Patch_ShowNames();
/*
	DD_Patch_ShowTriggerVolumes();
	DD_Patch_ShowFlags();
*/
	if (patch_flatline)
		DD_Patch_Flatline();

	return true;
}

