package net.oni2.aeinstaller.backend.oni.management;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;

import net.oni2.platformtools.applicationinvoker.ApplicationInvocationResult;

/**
 * @author Christian Illy
 */
public class Logger {
	PrintWriter log = null;

	/**
	 * @param logfile
	 *            File to log to
	 * @throws FileNotFoundException
	 *             Huh?
	 */
	public Logger(File logfile) throws FileNotFoundException {
		log = new PrintWriter(logfile);
	}

	/**
	 * Print an empty line
	 */
	public void println() {
		log.println();
	}

	/**
	 * Print a string as a line
	 * 
	 * @param line
	 *            String to print
	 */
	public void println(String line) {
		log.println(line);
	}

	/**
	 * Print a formatted string as a line
	 * 
	 * @param fmt
	 *            Format string
	 * @param args
	 *            Values
	 */
	public void printlnFmt(String fmt, Object... args) {
		log.println(String.format(fmt, args));
	}

	/**
	 * Close logger
	 */
	public void close() {
		log.close();
		log = null;
	}

	/**
	 * Log the application invocation result
	 * 
	 * @param result
	 *            App result
	 * @param onlyOnError
	 *            Print returned output only on errorcode != 0
	 */
	public void logAppOutput(ApplicationInvocationResult result,
			boolean onlyOnError) {
		if (result != null) {
			log.println("\t\t\tCalled:");
			for (String s : result.cmdLine)
				log.println("\t\t\t\t" + s);
			log.println("\t\t\tReturned: " + result.errorCode);
			if (!onlyOnError || result.errorCode != 0) {
				for (String s : result.output)
					log.println("\t\t\t\t" + s);
			}
			log.println("\t\t\tDuration: " + result.time + " ms");
			log.println();
		} else {
			log.println("\t\t\tExecution of external tool failed.");
		}
	}

}
