#include "bink-proxy.h"

#include <windows.h>
#include "Daodan_Utility.h"


static HMODULE realbink = 0;

typedef void (__stdcall *BINKBUFFERBLIT) (void* buf, void* rects, uint32_t numrects);
typedef void (__stdcall *BINKBUFFERCLOSE) (void* buf);
typedef int32_t (__stdcall *BINKBUFFERLOCK) (void* buf);
typedef void* (__stdcall *BINKBUFFEROPEN) (void* wnd, uint32_t width, uint32_t height, uint32_t bufferflags);
typedef int32_t (__stdcall *BINKBUFFERSETOFFSET) (void* buf, int32_t destx, int32_t desty);
typedef int32_t (__stdcall *BINKBUFFERUNLOCK) (void* buf);
typedef void (__stdcall *BINKCLOSE) (void* bnk);
typedef int32_t (__stdcall *BINKCOPYTOBUFFER) (void* bnk, void* dest, int32_t destpitch, uint32_t destheight, uint32_t destx, uint32_t desty, uint32_t flags);
typedef int32_t (__stdcall *BINKDOFRAME) (void* bnk);
typedef int32_t (__stdcall *BINKGETRECTS) (void* bnk, uint32_t flags);
typedef void (__stdcall *BINKNEXTFRAME) (void* bnk);
typedef void* (__stdcall *BINKOPEN) (const char* name, uint32_t flags);
typedef void* (__stdcall *BINKOPENDIRECTSOUND) (uint32_t param);
typedef void (__stdcall *BINKSERVICE) (void* bink);
typedef void (__stdcall *BINKSETIOSIZE) (uint32_t iosize);
typedef int32_t (__stdcall *BINKSETSOUNDONOFF) (void* bnk, int32_t onoff);
typedef int32_t (__stdcall *BINKSETSOUNDSYSTEM) (void* open, uint32_t param);
typedef void (__stdcall *BINKSETVOLUME) (void* bnk, int32_t volume);
typedef int32_t (__stdcall *BINKWAIT) (void* bnk);

static BINKBUFFERBLIT BinkBufferBlit = 0;
static BINKBUFFERCLOSE BinkBufferClose = 0;
static BINKBUFFERLOCK BinkBufferLock = 0;
static BINKBUFFEROPEN BinkBufferOpen = 0;
static BINKBUFFERSETOFFSET BinkBufferSetOffset = 0;
static BINKBUFFERUNLOCK BinkBufferUnlock = 0;
static BINKCLOSE BinkClose = 0;
static BINKCOPYTOBUFFER BinkCopyToBuffer = 0;
static BINKDOFRAME BinkDoFrame = 0;
static BINKGETRECTS BinkGetRects = 0;
static BINKNEXTFRAME BinkNextFrame = 0;
static BINKOPEN BinkOpen = 0;
static BINKOPENDIRECTSOUND BinkOpenDirectSound = 0;
static BINKSERVICE BinkService = 0;
static BINKSETIOSIZE BinkSetIOSize = 0;
static BINKSETSOUNDONOFF BinkSetSoundOnOff = 0;
static BINKSETSOUNDSYSTEM BinkSetSoundSystem = 0;
static BINKSETVOLUME BinkSetVolume = 0;
static BINKWAIT BinkWait = 0;


void __stdcall BinkProxyInit()
{
	if (GetFileAttributes("realbink.dll") != INVALID_FILE_ATTRIBUTES)
	{
		DWORD err;

 		DDrStartupMessage("Daodan: Loading real Bink DLL");
		realbink = LoadLibrary("realbink.dll");
		err = GetLastError();
		if(realbink)
		{

			BinkBufferBlit = (BINKBUFFERBLIT)GetProcAddress(realbink, "_BinkBufferBlit@12");
			if(!BinkBufferBlit)
			{
				DDrStartupMessage("Daodan: Retrieving function address from real Bink DLL failed for: BinkBufferBlit");
				goto exit_err;
			}
			BinkBufferClose = (BINKBUFFERCLOSE)GetProcAddress(realbink, "_BinkBufferClose@4");
			if(!BinkBufferClose)
			{
				DDrStartupMessage("Daodan: Retrieving function address from real Bink DLL failed for: BinkBufferClose");
				goto exit_err;
			}
			BinkBufferLock = (BINKBUFFERLOCK)GetProcAddress(realbink, "_BinkBufferLock@4");
			if(!BinkBufferLock)
			{
				DDrStartupMessage("Daodan: Retrieving function address from real Bink DLL failed for: BinkBufferLock");
				goto exit_err;
			}
			BinkBufferOpen = (BINKBUFFEROPEN)GetProcAddress(realbink, "_BinkBufferOpen@16");
			if(!BinkBufferOpen)
			{
				DDrStartupMessage("Daodan: Retrieving function address from real Bink DLL failed for: BinkBufferOpen");
				goto exit_err;
			}
			BinkBufferSetOffset = (BINKBUFFERSETOFFSET)GetProcAddress(realbink, "_BinkBufferSetOffset@12");
			if(!BinkBufferSetOffset)
			{
				DDrStartupMessage("Daodan: Retrieving function address from real Bink DLL failed for: BinkBufferSetOffset");
				goto exit_err;
			}
			BinkBufferUnlock = (BINKBUFFERUNLOCK)GetProcAddress(realbink, "_BinkBufferUnlock@4");
			if(!BinkBufferUnlock)
			{
				DDrStartupMessage("Daodan: Retrieving function address from real Bink DLL failed for: BinkBufferUnlock");
				goto exit_err;
			}
			BinkClose = (BINKCLOSE)GetProcAddress(realbink, "_BinkClose@4");
			if(!BinkClose)
			{
				DDrStartupMessage("Daodan: Retrieving function address from real Bink DLL failed for: BinkClose");
				goto exit_err;
			}
			BinkCopyToBuffer = (BINKCOPYTOBUFFER)GetProcAddress(realbink, "_BinkCopyToBuffer@28");
			if(!BinkCopyToBuffer)
			{
				DDrStartupMessage("Daodan: Retrieving function address from real Bink DLL failed for: BinkCopyToBuffer");
				goto exit_err;
			}
			BinkDoFrame = (BINKDOFRAME)GetProcAddress(realbink, "_BinkDoFrame@4");
			if(!BinkDoFrame)
			{
				DDrStartupMessage("Daodan: Retrieving function address from real Bink DLL failed for: BinkDoFrame");
				goto exit_err;
			}
			BinkGetRects = (BINKGETRECTS)GetProcAddress(realbink, "_BinkGetRects@8");
			if(!BinkGetRects)
			{
				DDrStartupMessage("Daodan: Retrieving function address from real Bink DLL failed for: BinkGetRects");
				goto exit_err;
			}
			BinkNextFrame = (BINKNEXTFRAME)GetProcAddress(realbink, "_BinkNextFrame@4");
			if(!BinkNextFrame)
			{
				DDrStartupMessage("Daodan: Retrieving function address from real Bink DLL failed for: BinkNextFrame");
				goto exit_err;
			}
			BinkOpen = (BINKOPEN)GetProcAddress(realbink, "_BinkOpen@8");
			if(!BinkOpen)
			{
				DDrStartupMessage("Daodan: Retrieving function address from real Bink DLL failed for: BinkOpen");
				goto exit_err;
			}
			BinkOpenDirectSound = (BINKOPENDIRECTSOUND)GetProcAddress(realbink, "_BinkOpenDirectSound@4");
			if(!BinkOpenDirectSound)
			{
				DDrStartupMessage("Daodan: Retrieving function address from real Bink DLL failed for: BinkOpenDirectSound");
				goto exit_err;
			}
			BinkService = (BINKSERVICE)GetProcAddress(realbink, "_BinkService@4");
			if(!BinkService)
			{
				DDrStartupMessage("Daodan: Retrieving function address from real Bink DLL failed for: BinkService");
				goto exit_err;
			}
			BinkSetIOSize = (BINKSETIOSIZE)GetProcAddress(realbink, "_BinkSetIOSize@4");
			if(!BinkSetIOSize)
			{
				DDrStartupMessage("Daodan: Retrieving function address from real Bink DLL failed for: BinkSetIOSize");
				goto exit_err;
			}
			BinkSetSoundOnOff = (BINKSETSOUNDONOFF)GetProcAddress(realbink, "_BinkSetSoundOnOff@8");
			if(!BinkSetSoundOnOff)
			{
				DDrStartupMessage("Daodan: Retrieving function address from real Bink DLL failed for: BinkSetSoundOnOff");
				goto exit_err;
			}
			BinkSetSoundSystem = (BINKSETSOUNDSYSTEM)GetProcAddress(realbink, "_BinkSetSoundSystem@8");
			if(!BinkSetSoundSystem)
			{
				DDrStartupMessage("Daodan: Retrieving function address from real Bink DLL failed for: BinkSetSoundSystem");
				goto exit_err;
			}
			BinkSetVolume = (BINKSETVOLUME)GetProcAddress(realbink, "_BinkSetVolume@8");
			if(!BinkSetVolume)
			{
				DDrStartupMessage("Daodan: Retrieving function address from real Bink DLL failed for: BinkSetVolume");
				goto exit_err;
			}
			BinkWait = (BINKWAIT)GetProcAddress(realbink, "_BinkWait@4");
			if(!BinkWait)
			{
				DDrStartupMessage("Daodan: Retrieving function address from real Bink DLL failed for: BinkWait");
				goto exit_err;
			}

		} else {
			char msg[100];
			FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, NULL, err, 0, msg, 100, NULL);
			DDrStartupMessage("Daodan: Loading real Bink DLL failed with error %i: %s", err, msg);
		}
	}

	return;

exit_err:
	realbink = 0;
	return;
}




void __stdcall _BinkBufferBlit(void* buf, void* rects, uint32_t numrects)
{
	if (realbink)
		BinkBufferBlit(buf, rects, numrects);
}

void __stdcall _BinkBufferClose(void* buf)
{
	if (realbink)
		BinkBufferClose(buf);
}

int32_t __stdcall _BinkBufferLock(void* buf)
{
	if (realbink)
		return BinkBufferLock(buf);
	return 0;
}

void* __stdcall _BinkBufferOpen(void* wnd, uint32_t width, uint32_t height, uint32_t bufferflags)
{
	if (realbink)
		return BinkBufferOpen(wnd, width, height, bufferflags);
	return 0;
}

int32_t __stdcall _BinkBufferSetOffset(void* buf, int32_t destx, int32_t desty)
{
	if (realbink)
		return BinkBufferSetOffset(buf, destx, desty);
	return 0;
}

int32_t __stdcall _BinkBufferUnlock(void* buf)
{
	if (realbink)
		return BinkBufferUnlock(buf);
	return 0;
}

void __stdcall _BinkClose(void* bnk)
{
	if (realbink)
		BinkClose(bnk);
}

int32_t __stdcall _BinkCopyToBuffer(void* bnk, void* dest, int32_t destpitch, uint32_t destheight, uint32_t destx, uint32_t desty, uint32_t flags)
{
	if (realbink)
		return BinkCopyToBuffer(bnk, dest, destpitch, destheight, destx, desty, flags);
	return 0;
}

int32_t __stdcall _BinkDoFrame(void* bnk)
{
	if (realbink)
		return BinkDoFrame(bnk);
	return 0;
}

int32_t __stdcall _BinkGetRects(void* bnk, uint32_t flags)
{
	if (realbink)
		return BinkGetRects(bnk, flags);
	return 0;
}

void __stdcall _BinkNextFrame(void* bnk)
{
	if (realbink)
		BinkNextFrame(bnk);
}

void* __stdcall _BinkOpen(const char* name, uint32_t flags)
{
	if (realbink)
		return BinkOpen(name, flags);
	return 0;
}

void* __stdcall _BinkOpenDirectSound(uint32_t param)
{
	if (realbink)
		return BinkOpenDirectSound(param);
	return 0;
}

void __stdcall _BinkService(void* bink)
{
	if (realbink)
		BinkService(bink);
}

void __stdcall _BinkSetIOSize(uint32_t iosize)
{
	if (realbink)
		BinkSetIOSize(iosize);
}

int32_t __stdcall _BinkSetSoundOnOff(void* bnk, int32_t onoff)
{
	if (realbink)
		return BinkSetSoundOnOff(bnk, onoff);
	return 0;
}

int32_t __stdcall _BinkSetSoundSystem(void* open, uint32_t param)
{
	if (realbink)
		return BinkSetSoundSystem(open, param);
	return 0;
}

void __stdcall _BinkSetVolume(void* bnk, int32_t volume)
{
	if (realbink)
		BinkSetVolume(bnk, volume);
}

int32_t __stdcall _BinkWait(void* bnk)
{
	if (realbink)
		return BinkWait(bnk);
	return 0;
}


