#include <windows.h>
#include <stdlib.h>
#include <stdarg.h>

#include "Daodan_Utility.h"
#include "Oni/Oni.h"

const double fps = 60.0;

void __cdecl DDrStartupMessage(const char* fmt, ...)
{

	char* buffer;
	va_list ap;
	va_start(ap, fmt);

	buffer = malloc(vsnprintf(NULL, 0, fmt, ap) + 1);
	
	vsprintf(buffer, fmt, ap);
	va_end(ap);

	if (!ONgFileStartup)
		if (!(ONgFileStartup = oni_fopen("startup.txt", "w")))
			return;

	oni_fprintf(ONgFileStartup, "%s\n", buffer);
	free(buffer);
	
	oni_fflush(ONgFileStartup);
	return;
}

int64_t ONICALL DDrMachineTime_Sixtieths()
{
	static uint32_t startticks = 0;
	double ticks = 0;
	
	if (startticks)
		ticks = GetTickCount() - startticks;
	else
		startticks = GetTickCount();
	
	return (int64_t)(ticks / 1000.0 * fps);
}

int64_t ONICALL DDrMachineTime_High()
{
//	LARGE_INTEGER PerfCount;
//	
//	if (!QueryPerformanceCounter(&PerfCount))
//		PerfCount.QuadPart = GetTickCount();
//	
//	return PerfCount.QuadPart;
	return GetTickCount();
}

double ONICALL DDrMachineTime_High_Frequency()
{
//	LARGE_INTEGER Frequency;
//
//	if (!QueryPerformanceFrequency(&Frequency))
		return 1000.0;
	
//	return Frequency.QuadPart;
}
	
void ONICALL DDrWeapon2Message(int* weapon, void* output_ptr) 
{
	char buffer[128] = {0};
	char* weapon_string = (char*)(*(weapon + 1)+0x5C);
	int16_t ammo = *(int16_t *)((int)weapon + 0x56);
	int16_t maxammo = *(int16_t *)(*(weapon + 1)+0xC0);
	float ratio = (float)ammo / (float)maxammo;
	
	char ammocolor;
	if		(ratio >= .9)	ammocolor = 'g';
	else if (ratio >= .5)	ammocolor = 'y';
	else if (ratio >= .2)	ammocolor = 'o';
	else					ammocolor = 'r';

	DDrMake_Weapon_Message( weapon_string, buffer); //gets the name of the weapon and formats it...probably doesn't need to be in seperate func.
	sprintf(SSrMessage_Find("autoprompt_weapon"), "%s |[%c.%i/%i]|", buffer, ammocolor, ammo, maxammo); //copies the new string to ONGS
	ONiGameState_FindAutoPromptMessage("weapon", output_ptr);	//does what the code i replaced does. Basically tells the game to show the msg.
}


void ONICALL DDrMake_Weapon_Message(char* weapon_string, char* output_ptr) 
{
	char* weapon_msg = NULL;	//The normal "You have recieved X" message.
	char weapon_name[64] = {'\0'};	//The stripped weapon name
	//TODO, someday: dynamically detect different keybindings.
	char default_msg[] = "Press [c.Q] to pick up weapon.";	//default return
	
	//Find the recieved message string
	weapon_msg = SSrMessage_Find(weapon_string);
	//this probably could be reorganized
	if(weapon_msg) {	//SSrMsgblah returns NULL if it can't find the message key
		memcpy(weapon_name, weapon_msg, (strstr(weapon_msg,"] ") - weapon_msg + 1)); //strips uneeded characters
		sprintf(output_ptr, "Press [c.Q] to pick up %s", weapon_name);
	}
	else {
		memcpy(output_ptr, default_msg, sizeof(default_msg));
	}
	
}

typedef struct
{
	uint16_t x;
	uint16_t y;

} IMtPoint2D;
IMtPoint2D Point = {256, 250};
extern void* TSrTest;
extern void* TSrScores;
unsigned int lastPasteTime;

//TODO: Fix what happens when you hold down paste
//Check if console is open
void DDrPasteHack()
{
	COtTextArea* cons = *(COtTextArea**)0x00571B74;
	char* clipboardText = 0;
	if(ONgGameState->Input.Current.Actions1 & Action_Console && GetKeyState(0x56) & 0x80 && GetKeyState(VK_CONTROL) & 0x80 )
	{
		if(cons && cons->text_entries && cons->num_text_entries)
		{
			//why abs()? so we dont have to reset the timer after a level load.
			if( abs(ONgGameState->GameTime - lastPasteTime) > 60) {
				//DDrConsole_Print(cons->text_entries[0].text);
				if(OpenClipboard(ONgPlatformData.Window))
				{
					unsigned short charsUsed = strlen(cons->text_entries[0].text);
					//get rid of the v character
					if(charsUsed) charsUsed--;
					clipboardText = GetClipboardData(CF_TEXT);
					if(clipboardText && strlen(clipboardText) + charsUsed < 502)
					{
						strcpy( cons->text_entries[0].text + charsUsed, clipboardText);
						lastPasteTime = ONgGameState->GameTime;
					}
					CloseClipboard();
				}

			}
			else
			{
				//need to hook whatever controls however often you can repeat characters...i guess.
				//cons->text_entries[0].text[strlen(cons->text_entries[0].text) - 1] = 0;
			}
		}
	}
}

void ONICALL DDrText_Hook()
{

	if(TSrTest)
	{
		TSrContext_DrawText(TSrTest, "FINALLY THIS BLOODY TEXT THING WORKS\n Gotta call it at the right point...", 128, 0, &Point);	

	}


	DDrPasteHack();
	
	COrConsole_StatusLine_Display();

}
