#ifndef ONI_H
#error Do not include this file directly, include Oni/Oni.h instead!
#endif

#ifndef GL_H
#define GL_H

typedef struct 
{
	int a;
	M3tDrawEngineCaps DrawEngineCaps;
	M3tDrawEngine DrawEngine;
	M3tDrawContext DrawContext;
	M3tDisplayMode DisplayMode;
	int b;
	int Textures[2];
	short c;
	short d;
	int IntState;
	M3tDrawPtrState *PtrState;
	int e;
	int Color;
	int MaxTextureSize;
	int DoubleBufferSupported;
	int MaxTextureUnits;
	char *VendorString;
	char *RendererString;
	char *VersionString;
	char *ExtensionsString;
	int MultipassCapable;
	int f_0588;
	char f_058C;
	char SupportsDepthReads;
	char FogDisabled;
	char f_058F;
	int CompressedTextureFormats[16];
	int NumCompressedTextureFormats;
	int f_05D4;
	float FogStart;
	float FogEnd;
	char FogStartChanged;
	char FogEndChanged;
	short f_05E2;
	int f_05E4[4];
	float FogColor_R;
	float FogColor_G;
	float FogColor_B;
	int Fog_1_;
	char Fog_2_;
	char f_0605[3];
	float ClearColor[4];
	int LastError;
	char *LastErrorString;
	short RenderMode;
	char BufferClear;
	char DoubleBuffer;
	int f_0624;
	char *TextureBuffer;
	HDC hDC;
	HGLRC hGLRC;
	char vsync;
	char f_0635[3];
	void (*DisplayBackBuffer)(void);
} gl_engine_t;

typedef struct
{
	void (WINAPI *glAccum)(GLenum op, GLfloat value);
	void (WINAPI *glAlphaFunc)(GLenum func, GLclampf ref);
	GLboolean (WINAPI *glAreTexturesResident)(GLsizei n, const GLuint *textures, GLboolean *residences);
	void (WINAPI *glArrayElement)(GLint i);
	void (WINAPI *glBegin)(GLenum mode);
	void (WINAPI *glBindTexture)(GLenum target, GLuint texture);
	void (WINAPI *glBitmap)(GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte *bitmap);
	void (WINAPI *glBlendFunc)(GLenum sfactor, GLenum dfactor);
	void (WINAPI *glCallList)(GLuint list);
	void (WINAPI *glCallLists)(GLsizei n, GLenum type, const GLvoid *lists);
	void (WINAPI *glClear)(GLbitfield mask);
	void (WINAPI *glClearAccum)(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
	void (WINAPI *glClearColor)(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
	void (WINAPI *glClearDepth)(GLclampd depth);
	void (WINAPI *glClearIndex)(GLfloat c);
	void (WINAPI *glClearStencil)(GLint s);
	void (WINAPI *glClipPlane)(GLenum plane, const GLdouble *equation);
	void (WINAPI *glColor3b)(GLbyte red, GLbyte green, GLbyte blue);
	void (WINAPI *glColor3bv)(const GLbyte *v);
	void (WINAPI *glColor3d)(GLdouble red, GLdouble green, GLdouble blue);
	void (WINAPI *glColor3dv)(const GLdouble *v);
	void (WINAPI *glColor3f)(GLfloat red, GLfloat green, GLfloat blue);
	void (WINAPI *glColor3fv)(const GLfloat *v);
	void (WINAPI *glColor3i)(GLint red, GLint green, GLint blue);
	void (WINAPI *glColor3iv)(const GLint *v);
	void (WINAPI *glColor3s)(GLshort red, GLshort green, GLshort blue);
	void (WINAPI *glColor3sv)(const GLshort *v);
	void (WINAPI *glColor3ub)(GLubyte red, GLubyte green, GLubyte blue);
	void (WINAPI *glColor3ubv)(const GLubyte *v);
	void (WINAPI *glColor3ui)(GLuint red, GLuint green, GLuint blue);
	void (WINAPI *glColor3uiv)(const GLuint *v);
	void (WINAPI *glColor3us)(GLushort red, GLushort green, GLushort blue);
	void (WINAPI *glColor3usv)(const GLushort *v);
	void (WINAPI *glColor4b)(GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha);
	void (WINAPI *glColor4bv)(const GLbyte *v);
	void (WINAPI *glColor4d)(GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha);
	void (WINAPI *glColor4dv)(const GLdouble *v);
	void (WINAPI *glColor4f)(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
	void (WINAPI *glColor4fv)(const GLfloat *v);
	void (WINAPI *glColor4i)(GLint red, GLint green, GLint blue, GLint alpha);
	void (WINAPI *glColor4iv)(const GLint *v);
	void (WINAPI *glColor4s)(GLshort red, GLshort green, GLshort blue, GLshort alpha);
	void (WINAPI *glColor4sv)(const GLshort *v);
	void (WINAPI *glColor4ub)(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha);
	void (WINAPI *glColor4ubv)(const GLubyte *v);
	void (WINAPI *glColor4ui)(GLuint red, GLuint green, GLuint blue, GLuint alpha);
	void (WINAPI *glColor4uiv)(const GLuint *v);
	void (WINAPI *glColor4us)(GLushort red, GLushort green, GLushort blue, GLushort alpha);
	void (WINAPI *glColor4usv)(const GLushort *v);
	void (WINAPI *glColorMask)(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha);
	void (WINAPI *glColorMaterial)(GLenum face, GLenum mode);
	void (WINAPI *glColorPointer)(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
	void (WINAPI *glCopyPixels)(GLint x, GLint y, GLsizei width, GLsizei height, GLenum type);
	void (WINAPI *glCopyTexImage1D)(GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLint border);
	void (WINAPI *glCopyTexImage2D)(GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border);
	void (WINAPI *glCopyTexSubImage1D)(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width);
	void (WINAPI *glCopyTexSubImage2D)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
	void (WINAPI *glCullFace)(GLenum mode);
	void (WINAPI *glDeleteLists)(GLuint list, GLsizei range);
	void (WINAPI *glDeleteTextures)(GLsizei n, const GLuint *textures);
	void (WINAPI *glDepthFunc)(GLenum func);
	void (WINAPI *glDepthMask)(GLboolean flag);
	void (WINAPI *glDepthRange)(GLclampd zNear, GLclampd zFar);
	void (WINAPI *glDisable)(GLenum cap);
	void (WINAPI *glDisableClientState)(GLenum array);
	void (WINAPI *glDrawArrays)(GLenum mode, GLint first, GLsizei count);
	void (WINAPI *glDrawBuffer)(GLenum mode);
	void (WINAPI *glDrawElements)(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices);
	void (WINAPI *glDrawPixels)(GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
	void (WINAPI *glEdgeFlag)(GLboolean flag);
	void (WINAPI *glEdgeFlagPointer)(GLsizei stride, const GLvoid *pointer);
	void (WINAPI *glEdgeFlagv)(const GLboolean *flag);
	void (WINAPI *glEnable)(GLenum cap);
	void (WINAPI *glEnableClientState)(GLenum array);
	void (WINAPI *glEnd)(void);
	void (WINAPI *glEndList)(void);
	void (WINAPI *glEvalCoord1d)(GLdouble u);
	void (WINAPI *glEvalCoord1dv)(const GLdouble *u);
	void (WINAPI *glEvalCoord1f)(GLfloat u);
	void (WINAPI *glEvalCoord1fv)(const GLfloat *u);
	void (WINAPI *glEvalCoord2d)(GLdouble u, GLdouble v);
	void (WINAPI *glEvalCoord2dv)(const GLdouble *u);
	void (WINAPI *glEvalCoord2f)(GLfloat u, GLfloat v);
	void (WINAPI *glEvalCoord2fv)(const GLfloat *u);
	void (WINAPI *glEvalMesh1)(GLenum mode, GLint i1, GLint i2);
	void (WINAPI *glEvalMesh2)(GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2);
	void (WINAPI *glEvalPoint1)(GLint i);
	void (WINAPI *glEvalPoint2)(GLint i, GLint j);
	void (WINAPI *glFeedbackBuffer)(GLsizei size, GLenum type, GLfloat *buffer);
	void (WINAPI *glFinish)(void);
	void (WINAPI *glFlush)(void);
	void (WINAPI *glFogf)(GLenum pname, GLfloat param);
	void (WINAPI *glFogfv)(GLenum pname, const GLfloat *params);
	void (WINAPI *glFogi)(GLenum pname, GLint param);
	void (WINAPI *glFogiv)(GLenum pname, const GLint *params);
	void (WINAPI *glFrontFace)(GLenum mode);
	void (WINAPI *glFrustum)(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar);
	GLuint (WINAPI *glGenLists)(GLsizei range);
	void (WINAPI *glGenTextures)(GLsizei n, GLuint *textures);
	void (WINAPI *glGetBooleanv)(GLenum pname, GLboolean *params);
	void (WINAPI *glGetClipPlane)(GLenum plane, GLdouble *equation);
	void (WINAPI *glGetDoublev)(GLenum pname, GLdouble *params);
	GLenum (WINAPI *glGetError)(void);
	void (WINAPI *glGetFloatv)(GLenum pname, GLfloat *params);
	void (WINAPI *glGetIntegerv)(GLenum pname, GLint *params);
	void (WINAPI *glGetLightfv)(GLenum light, GLenum pname, GLfloat *params);
	void (WINAPI *glGetLightiv)(GLenum light, GLenum pname, GLint *params);
	void (WINAPI *glGetMapdv)(GLenum target, GLenum query, GLdouble *v);
	void (WINAPI *glGetMapfv)(GLenum target, GLenum query, GLfloat *v);
	void (WINAPI *glGetMapiv)(GLenum target, GLenum query, GLint *v);
	void (WINAPI *glGetMaterialfv)(GLenum face, GLenum pname, GLfloat *params);
	void (WINAPI *glGetMaterialiv)(GLenum face, GLenum pname, GLint *params);
	void (WINAPI *glGetPixelMapfv)(GLenum map, GLfloat *values);
	void (WINAPI *glGetPixelMapuiv)(GLenum map, GLuint *values);
	void (WINAPI *glGetPixelMapusv)(GLenum map, GLushort *values);
	void (WINAPI *glGetPointerv)(GLenum pname, GLvoid* *params);
	void (WINAPI *glGetPolygonStipple)(GLubyte *mask);
	const GLubyte * (WINAPI *glGetString)(GLenum name);
	void (WINAPI *glGetTexEnvfv)(GLenum target, GLenum pname, GLfloat *params);
	void (WINAPI *glGetTexEnviv)(GLenum target, GLenum pname, GLint *params);
	void (WINAPI *glGetTexGendv)(GLenum coord, GLenum pname, GLdouble *params);
	void (WINAPI *glGetTexGenfv)(GLenum coord, GLenum pname, GLfloat *params);
	void (WINAPI *glGetTexGeniv)(GLenum coord, GLenum pname, GLint *params);
	void (WINAPI *glGetTexImage)(GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels);
	void (WINAPI *glGetTexLevelParameterfv)(GLenum target, GLint level, GLenum pname, GLfloat *params);
	void (WINAPI *glGetTexLevelParameteriv)(GLenum target, GLint level, GLenum pname, GLint *params);
	void (WINAPI *glGetTexParameterfv)(GLenum target, GLenum pname, GLfloat *params);
	void (WINAPI *glGetTexParameteriv)(GLenum target, GLenum pname, GLint *params);
	void (WINAPI *glHint)(GLenum target, GLenum mode);
	void (WINAPI *glIndexMask)(GLuint mask);
	void (WINAPI *glIndexPointer)(GLenum type, GLsizei stride, const GLvoid *pointer);
	void (WINAPI *glIndexd)(GLdouble c);
	void (WINAPI *glIndexdv)(const GLdouble *c);
	void (WINAPI *glIndexf)(GLfloat c);
	void (WINAPI *glIndexfv)(const GLfloat *c);
	void (WINAPI *glIndexi)(GLint c);
	void (WINAPI *glIndexiv)(const GLint *c);
	void (WINAPI *glIndexs)(GLshort c);
	void (WINAPI *glIndexsv)(const GLshort *c);
	void (WINAPI *glIndexub)(GLubyte c);
	void (WINAPI *glIndexubv)(const GLubyte *c);
	void (WINAPI *glInitNames)(void);
	void (WINAPI *glInterleavedArrays)(GLenum format, GLsizei stride, const GLvoid *pointer);
	GLboolean (WINAPI *glIsEnabled)(GLenum cap);
	GLboolean (WINAPI *glIsList)(GLuint list);
	GLboolean (WINAPI *glIsTexture)(GLuint texture);
	void (WINAPI *glLightModelf)(GLenum pname, GLfloat param);
	void (WINAPI *glLightModelfv)(GLenum pname, const GLfloat *params);
	void (WINAPI *glLightModeli)(GLenum pname, GLint param);
	void (WINAPI *glLightModeliv)(GLenum pname, const GLint *params);
	void (WINAPI *glLightf)(GLenum light, GLenum pname, GLfloat param);
	void (WINAPI *glLightfv)(GLenum light, GLenum pname, const GLfloat *params);
	void (WINAPI *glLighti)(GLenum light, GLenum pname, GLint param);
	void (WINAPI *glLightiv)(GLenum light, GLenum pname, const GLint *params);
	void (WINAPI *glLineStipple)(GLint factor, GLushort pattern);
	void (WINAPI *glLineWidth)(GLfloat width);
	void (WINAPI *glListBase)(GLuint base);
	void (WINAPI *glLoadIdentity)(void);
	void (WINAPI *glLoadMatrixd)(const GLdouble *m);
	void (WINAPI *glLoadMatrixf)(const GLfloat *m);
	void (WINAPI *glLoadName)(GLuint name);
	void (WINAPI *glLogicOp)(GLenum opcode);
	void (WINAPI *glMap1d)(GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points);
	void (WINAPI *glMap1f)(GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points);
	void (WINAPI *glMap2d)(GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points);
	void (WINAPI *glMap2f)(GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points);
	void (WINAPI *glMapGrid1d)(GLint un, GLdouble u1, GLdouble u2);
	void (WINAPI *glMapGrid1f)(GLint un, GLfloat u1, GLfloat u2);
	void (WINAPI *glMapGrid2d)(GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2);
	void (WINAPI *glMapGrid2f)(GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2);
	void (WINAPI *glMaterialf)(GLenum face, GLenum pname, GLfloat param);
	void (WINAPI *glMaterialfv)(GLenum face, GLenum pname, const GLfloat *params);
	void (WINAPI *glMateriali)(GLenum face, GLenum pname, GLint param);
	void (WINAPI *glMaterialiv)(GLenum face, GLenum pname, const GLint *params);
	void (WINAPI *glMatrixMode)(GLenum mode);
	void (WINAPI *glMultMatrixd)(const GLdouble *m);
	void (WINAPI *glMultMatrixf)(const GLfloat *m);
	void (WINAPI *glNewList)(GLuint list, GLenum mode);
	void (WINAPI *glNormal3b)(GLbyte nx, GLbyte ny, GLbyte nz);
	void (WINAPI *glNormal3bv)(const GLbyte *v);
	void (WINAPI *glNormal3d)(GLdouble nx, GLdouble ny, GLdouble nz);
	void (WINAPI *glNormal3dv)(const GLdouble *v);
	void (WINAPI *glNormal3f)(GLfloat nx, GLfloat ny, GLfloat nz);
	void (WINAPI *glNormal3fv)(const GLfloat *v);
	void (WINAPI *glNormal3i)(GLint nx, GLint ny, GLint nz);
	void (WINAPI *glNormal3iv)(const GLint *v);
	void (WINAPI *glNormal3s)(GLshort nx, GLshort ny, GLshort nz);
	void (WINAPI *glNormal3sv)(const GLshort *v);
	void (WINAPI *glNormalPointer)(GLenum type, GLsizei stride, const GLvoid *pointer);
	void (WINAPI *glOrtho)(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar);
	void (WINAPI *glPassThrough)(GLfloat token);
	void (WINAPI *glPixelMapfv)(GLenum map, GLsizei mapsize, const GLfloat *values);
	void (WINAPI *glPixelMapuiv)(GLenum map, GLsizei mapsize, const GLuint *values);
	void (WINAPI *glPixelMapusv)(GLenum map, GLsizei mapsize, const GLushort *values);
	void (WINAPI *glPixelStoref)(GLenum pname, GLfloat param);
	void (WINAPI *glPixelStorei)(GLenum pname, GLint param);
	void (WINAPI *glPixelTransferf)(GLenum pname, GLfloat param);
	void (WINAPI *glPixelTransferi)(GLenum pname, GLint param);
	void (WINAPI *glPixelZoom)(GLfloat xfactor, GLfloat yfactor);
	void (WINAPI *glPointSize)(GLfloat size);
	void (WINAPI *glPolygonMode)(GLenum face, GLenum mode);
	void (WINAPI *glPolygonOffset)(GLfloat factor, GLfloat units);
	void (WINAPI *glPolygonStipple)(const GLubyte *mask);
	void (WINAPI *glPopAttrib)(void);
	void (WINAPI *glPopClientAttrib)(void);
	void (WINAPI *glPopMatrix)(void);
	void (WINAPI *glPopName)(void);
	void (WINAPI *glPrioritizeTextures)(GLsizei n, const GLuint *textures, const GLclampf *priorities);
	void (WINAPI *glPushAttrib)(GLbitfield mask);
	void (WINAPI *glPushClientAttrib)(GLbitfield mask);
	void (WINAPI *glPushMatrix)(void);
	void (WINAPI *glPushName)(GLuint name);
	void (WINAPI *glRasterPos2d)(GLdouble x, GLdouble y);
	void (WINAPI *glRasterPos2dv)(const GLdouble *v);
	void (WINAPI *glRasterPos2f)(GLfloat x, GLfloat y);
	void (WINAPI *glRasterPos2fv)(const GLfloat *v);
	void (WINAPI *glRasterPos2i)(GLint x, GLint y);
	void (WINAPI *glRasterPos2iv)(const GLint *v);
	void (WINAPI *glRasterPos2s)(GLshort x, GLshort y);
	void (WINAPI *glRasterPos2sv)(const GLshort *v);
	void (WINAPI *glRasterPos3d)(GLdouble x, GLdouble y, GLdouble z);
	void (WINAPI *glRasterPos3dv)(const GLdouble *v);
	void (WINAPI *glRasterPos3f)(GLfloat x, GLfloat y, GLfloat z);
	void (WINAPI *glRasterPos3fv)(const GLfloat *v);
	void (WINAPI *glRasterPos3i)(GLint x, GLint y, GLint z);
	void (WINAPI *glRasterPos3iv)(const GLint *v);
	void (WINAPI *glRasterPos3s)(GLshort x, GLshort y, GLshort z);
	void (WINAPI *glRasterPos3sv)(const GLshort *v);
	void (WINAPI *glRasterPos4d)(GLdouble x, GLdouble y, GLdouble z, GLdouble w);
	void (WINAPI *glRasterPos4dv)(const GLdouble *v);
	void (WINAPI *glRasterPos4f)(GLfloat x, GLfloat y, GLfloat z, GLfloat w);
	void (WINAPI *glRasterPos4fv)(const GLfloat *v);
	void (WINAPI *glRasterPos4i)(GLint x, GLint y, GLint z, GLint w);
	void (WINAPI *glRasterPos4iv)(const GLint *v);
	void (WINAPI *glRasterPos4s)(GLshort x, GLshort y, GLshort z, GLshort w);
	void (WINAPI *glRasterPos4sv)(const GLshort *v);
	void (WINAPI *glReadBuffer)(GLenum mode);
	void (WINAPI *glReadPixels)(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels);
	void (WINAPI *glRectd)(GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2);
	void (WINAPI *glRectdv)(const GLdouble *v1, const GLdouble *v2);
	void (WINAPI *glRectf)(GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2);
	void (WINAPI *glRectfv)(const GLfloat *v1, const GLfloat *v2);
	void (WINAPI *glRecti)(GLint x1, GLint y1, GLint x2, GLint y2);
	void (WINAPI *glRectiv)(const GLint *v1, const GLint *v2);
	void (WINAPI *glRects)(GLshort x1, GLshort y1, GLshort x2, GLshort y2);
	void (WINAPI *glRectsv)(const GLshort *v1, const GLshort *v2);
	GLint (WINAPI *glRenderMode)(GLenum mode);
	void (WINAPI *glRotated)(GLdouble angle, GLdouble x, GLdouble y, GLdouble z);
	void (WINAPI *glRotatef)(GLfloat angle, GLfloat x, GLfloat y, GLfloat z);
	void (WINAPI *glScaled)(GLdouble x, GLdouble y, GLdouble z);
	void (WINAPI *glScalef)(GLfloat x, GLfloat y, GLfloat z);
	void (WINAPI *glScissor)(GLint x, GLint y, GLsizei width, GLsizei height);
	void (WINAPI *glSelectBuffer)(GLsizei size, GLuint *buffer);
	void (WINAPI *glShadeModel)(GLenum mode);
	void (WINAPI *glStencilFunc)(GLenum func, GLint ref, GLuint mask);
	void (WINAPI *glStencilMask)(GLuint mask);
	void (WINAPI *glStencilOp)(GLenum fail, GLenum zfail, GLenum zpass);
	void (WINAPI *glTexCoord1d)(GLdouble s);
	void (WINAPI *glTexCoord1dv)(const GLdouble *v);
	void (WINAPI *glTexCoord1f)(GLfloat s);
	void (WINAPI *glTexCoord1fv)(const GLfloat *v);
	void (WINAPI *glTexCoord1i)(GLint s);
	void (WINAPI *glTexCoord1iv)(const GLint *v);
	void (WINAPI *glTexCoord1s)(GLshort s);
	void (WINAPI *glTexCoord1sv)(const GLshort *v);
	void (WINAPI *glTexCoord2d)(GLdouble s, GLdouble t);
	void (WINAPI *glTexCoord2dv)(const GLdouble *v);
	void (WINAPI *glTexCoord2f)(GLfloat s, GLfloat t);
	void (WINAPI *glTexCoord2fv)(const GLfloat *v);
	void (WINAPI *glTexCoord2i)(GLint s, GLint t);
	void (WINAPI *glTexCoord2iv)(const GLint *v);
	void (WINAPI *glTexCoord2s)(GLshort s, GLshort t);
	void (WINAPI *glTexCoord2sv)(const GLshort *v);
	void (WINAPI *glTexCoord3d)(GLdouble s, GLdouble t, GLdouble r);
	void (WINAPI *glTexCoord3dv)(const GLdouble *v);
	void (WINAPI *glTexCoord3f)(GLfloat s, GLfloat t, GLfloat r);
	void (WINAPI *glTexCoord3fv)(const GLfloat *v);
	void (WINAPI *glTexCoord3i)(GLint s, GLint t, GLint r);
	void (WINAPI *glTexCoord3iv)(const GLint *v);
	void (WINAPI *glTexCoord3s)(GLshort s, GLshort t, GLshort r);
	void (WINAPI *glTexCoord3sv)(const GLshort *v);
	void (WINAPI *glTexCoord4d)(GLdouble s, GLdouble t, GLdouble r, GLdouble q);
	void (WINAPI *glTexCoord4dv)(const GLdouble *v);
	void (WINAPI *glTexCoord4f)(GLfloat s, GLfloat t, GLfloat r, GLfloat q);
	void (WINAPI *glTexCoord4fv)(const GLfloat *v);
	void (WINAPI *glTexCoord4i)(GLint s, GLint t, GLint r, GLint q);
	void (WINAPI *glTexCoord4iv)(const GLint *v);
	void (WINAPI *glTexCoord4s)(GLshort s, GLshort t, GLshort r, GLshort q);
	void (WINAPI *glTexCoord4sv)(const GLshort *v);
	void (WINAPI *glTexCoordPointer)(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
	void (WINAPI *glTexEnvf)(GLenum target, GLenum pname, GLfloat param);
	void (WINAPI *glTexEnvfv)(GLenum target, GLenum pname, const GLfloat *params);
	void (WINAPI *glTexEnvi)(GLenum target, GLenum pname, GLint param);
	void (WINAPI *glTexEnviv)(GLenum target, GLenum pname, const GLint *params);
	void (WINAPI *glTexGend)(GLenum coord, GLenum pname, GLdouble param);
	void (WINAPI *glTexGendv)(GLenum coord, GLenum pname, const GLdouble *params);
	void (WINAPI *glTexGenf)(GLenum coord, GLenum pname, GLfloat param);
	void (WINAPI *glTexGenfv)(GLenum coord, GLenum pname, const GLfloat *params);
	void (WINAPI *glTexGeni)(GLenum coord, GLenum pname, GLint param);
	void (WINAPI *glTexGeniv)(GLenum coord, GLenum pname, const GLint *params);
	void (WINAPI *glTexImage1D)(GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
	void (WINAPI *glTexImage2D)(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
	void (WINAPI *glTexParameterf)(GLenum target, GLenum pname, GLfloat param);
	void (WINAPI *glTexParameterfv)(GLenum target, GLenum pname, const GLfloat *params);
	void (WINAPI *glTexParameteri)(GLenum target, GLenum pname, GLint param);
	void (WINAPI *glTexParameteriv)(GLenum target, GLenum pname, const GLint *params);
	void (WINAPI *glTexSubImage1D)(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels);
	void (WINAPI *glTexSubImage2D)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
	void (WINAPI *glTranslated)(GLdouble x, GLdouble y, GLdouble z);
	void (WINAPI *glTranslatef)(GLfloat x, GLfloat y, GLfloat z);
	void (WINAPI *glVertex2d)(GLdouble x, GLdouble y);
	void (WINAPI *glVertex2dv)(const GLdouble *v);
	void (WINAPI *glVertex2f)(GLfloat x, GLfloat y);
	void (WINAPI *glVertex2fv)(const GLfloat *v);
	void (WINAPI *glVertex2i)(GLint x, GLint y);
	void (WINAPI *glVertex2iv)(const GLint *v);
	void (WINAPI *glVertex2s)(GLshort x, GLshort y);
	void (WINAPI *glVertex2sv)(const GLshort *v);
	void (WINAPI *glVertex3d)(GLdouble x, GLdouble y, GLdouble z);
	void (WINAPI *glVertex3dv)(const GLdouble *v);
	void (WINAPI *glVertex3f)(GLfloat x, GLfloat y, GLfloat z);
	void (WINAPI *glVertex3fv)(const GLfloat *v);
	void (WINAPI *glVertex3i)(GLint x, GLint y, GLint z);
	void (WINAPI *glVertex3iv)(const GLint *v);
	void (WINAPI *glVertex3s)(GLshort x, GLshort y, GLshort z);
	void (WINAPI *glVertex3sv)(const GLshort *v);
	void (WINAPI *glVertex4d)(GLdouble x, GLdouble y, GLdouble z, GLdouble w);
	void (WINAPI *glVertex4dv)(const GLdouble *v);
	void (WINAPI *glVertex4f)(GLfloat x, GLfloat y, GLfloat z, GLfloat w);
	void (WINAPI *glVertex4fv)(const GLfloat *v);
	void (WINAPI *glVertex4i)(GLint x, GLint y, GLint z, GLint w);
	void (WINAPI *glVertex4iv)(const GLint *v);
	void (WINAPI *glVertex4s)(GLshort x, GLshort y, GLshort z, GLshort w);
	void (WINAPI *glVertex4sv)(const GLshort *v);
	void (WINAPI *glVertexPointer)(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
	void (WINAPI *glViewport)(GLint x, GLint y, GLsizei width, GLsizei height);

	BOOL  (WINAPI *wglCopyContext)(HGLRC, HGLRC, UINT);
	HGLRC (WINAPI *wglCreateContext)(HDC);
	HGLRC (WINAPI *wglCreateLayerContext)(HDC, int);
	BOOL  (WINAPI *wglDeleteContext)(HGLRC);
	HGLRC (WINAPI *wglGetCurrentContext)(VOID);
	HDC   (WINAPI *wglGetCurrentDC)(VOID);
	PROC  (WINAPI *wglGetProcAddress)(LPCSTR);
	BOOL  (WINAPI *wglMakeCurrent)(HDC, HGLRC);
	BOOL  (WINAPI *wglShareLists)(HGLRC, HGLRC);

	int f_0564;

	int glActiveTextureARB;
	int glClientActiveTextureARB;
	int glMultiTexCoord4fARB;
	int glMultiTexCoord2fvARB;
	int glBlendColor;
	int f_057C;
	int f_0580;
	int f_0584;
	int f_0588;
	int glCompressedTexImaged3DARB;
	int glCompressedTexImaged2DARB;
	int glCompressedTexImage1DARB;
	int glCompressedTexSubImage3DARB;
	int glCompressedTexSubImage2DARB;
	int glCompressedTexSubImage1DARB;
	int glCompressedTexImageARB;

	GLboolean (WINAPI *wglSwapIntervalEXT)(GLint interval);

	GLint (WINAPI *wglSetDeviceGammaRamp3DFX)(HDC, M3tWin32GammaRamp*);
	GLint (WINAPI *wglGetDeviceGammaRamp3DFX)(HDC, M3tWin32GammaRamp*);
} gl_api_t;


#endif
