#ifndef ONI_H
#error Do not include this file directly, include Oni/Oni.h instead!
#endif

#ifndef BFW_SCRIPTLANG_H
#define BFW_SCRIPTLANG_H

typedef enum {
	sl_int32,
	sl_str32,
	sl_float,
	sl_bool,  /* Actually int32 0 or 1. */
	sl_void,
} sl_type;

typedef struct {
	sl_type type;
	union {
		void*   value;
		int32_t value_int32;
		char*   value_str32;
		float   value_float;
		char    value_bool;
	} val;
} sl_arg;

typedef struct {
	char*    name;
	char*    calllocation; //maybe
	int      linenumber;   //perhaps
} sl_callinfo;

// Method signature for script (BSL) functions
typedef uint16_t	( ONICALL *sl_func)(sl_callinfo* callinfo, uint32_t numargs, sl_arg args[], int* dontuse1, int* dontuse2, sl_arg* ret);


#endif
