#ifndef ONI_H
#error Do not include this file directly, include Oni/Oni.h instead!
#endif

#ifndef CHARACTER_H
#define CHARACTER_H

enum {
	team_konoko,
	team_tctf,
	team_syndicate,
	team_neutral,
	team_securityguard,
	team_roguekonoko,
	team_switzerland,
	team_syndicateaccessory,
};


//We need a Oni_Structs #include file.

typedef enum {
	ONcCharacterFlag_Dead_1_Animating		=	0x00000001,	// health is 0
	ONcCharacterFlag_Dead					=	ONcCharacterFlag_Dead_1_Animating,
	ONcCharacterFlag_Dead_2_Moving			=	0x00000002,	// no longer animating
	ONcCharacterFlag_Dead_3_Cosmetic		=	0x00000004,	// no longer moving
	ONcCharacterFlag_Dead_4_Gone			=	0x00000008,	// dead except but still drawn

	ONcCharacterFlag_HastyAnim				=	0x00000010,	// do this queued animation ASAP
	ONcCharacterFlag_Unkillable				=	0x00000020,	// the character cannot be killed, only defeated
	ONcCharacterFlag_InfiniteAmmo			=	0x00000040,	// the character always has infinite ammo
	ONcCharacterFlag_PleaseBlock			=	0x00000080,	// set if the character should block, cleared once block begins
	
	ONcCharacterFlag_Unstoppable			=	0x00000100,	// this character cannot be knocked down, staggered, stunned, etc
	ONcCharacterFlag_ScriptControl			=	0x00000200,	// set if the character is completely under script control
	ONcCharacterFlag_DeathLock				=	0x00000400,	// this character should never die all the way
	ONcCharacterFlag_WasUpdated				=	0x00000800,	// this character's animation was changed
		
	ONcCharacterFlag_BeingThrown			=	0x00001000,	// this character is being thrown
	ONcCharacterFlag_DontUseGunVariant		=	0x00002000,	// this character should not use a weapon variant
	ONcCharacterFlag_Draw					=	0x00004000,	// DoFrame has been executed for this character
	ONcCharacterFlag_InUse					=	0x00008000,	// this character is active and in use

	ONcCharacterFlag_DontUseFightVariant	=	0x00010000,
	ONcCharacterFlag_NoCollision			=	0x00020000,	// no collision for this character
	ONcCharacterFlag_Teleporting			=	0x00040000,	// this character is teleporting and does not accept collision
	ONcCharacterFlag_NoCorpse				=	0x00080000,	// no corpse for this character

	ONcCharacterFlag_ActiveLock				=	0x00100000,	// the character is locked active
	ONcCharacterFlag_ChrAnimate				=	0x00200000,	// the character is currently runing a chr_animate command
	ONcCharacterFlag_AIMovement				=	0x00400000,	// the character is using AI movement
	ONcCharacterFlag_NeutralUninterruptible	=	0x00800000,	// running an uninterruptible neutral interaction

	ONcCharacterFlag_NoShadow				=	0x01000000,	// 
	ONcCharacterFlag_Invincible				=	0x02000000,	// character is invincible
	ONcCharacterFlag_NoAutoDrop				=	0x04000000,	// character should not automatically drop items when killed (invisibility, shield, LSI)
	ONcCharacterFlag_RestrictedMovement		=	0x08000000,	// character cannot move fast (used for player holding barabbas' gun)

	ONcCharacterFlag_Boss					=	0x10000000,	// character is a boss (used for final muro group fight)
	ONcCharacterFlag_FinalFlash				=	0x20000000,	// 'final flash' has been played for this character's death
	ONcCharacterFlag_BossShield				=	0x40000000, // this character has the boss shield
	ONcCharacterFlag_WeaponImmune			=	0x80000000	// this character is immune to weapon damage

} ONtCharacterFlags;

typedef enum {
	ONcCharacterFlag2_WeaponEmpty			=	0x00000001, // character's weapon is empty, punch instead
	ONcCharacterFlag2_UltraMode				=	0x00000002

} ONtCharacterFlags2;

#endif
