#ifndef ONI_H
#error Do not include this file directly, include Oni/Oni.h instead!
#endif

#ifndef OBJT_H
#define OBJT_H

// Used by function definition below: OBJrObjectType_EnumerateObjects
typedef char		( ONICALL *OBJtEnumCallback_Object)(void *inObject, int inUserData);

typedef struct OBJtMethods
{
	void* rNew;
	void* rSetDefaults;
	void* rDelete;
	void* rIsInvalid;
	void* rLevelBegin;
	void* rLevelEnd;

	void* rDraw;
	void* rEnumerate;
	void* rGetBoundingSphere;
	void* rOSDGetName;
	void* rOSDSetName;
	void* rIntersectsLine;
	void* rUpdatePosition;

	void* rGetOSD;
	void* rGetOSDWriteSize;
	void* rSetOSD;

	void* rWrite;
	void* rRead;

	void* rSearch;

	void* rGetClassVisible;
	void* rSetClassVisible;

	void* rGetUniqueOSD;
} OBJtMethods;

//typedef OBJtObjectType;

typedef struct OBJtObject
{
	uint32_t object_type;
	uint32_t object_id;
	uint32_t flags;
	M3tPoint3D position;
	M3tPoint3D rotation;
	OBJtMethods* methods;
	void* mechanics_class; //ONtMechanicsClass* mechanics_class;
	uint32_t object_data[0];
} OBJtObject;

#define OBJcMaxNameLength 63
#define OBJcMaxNoteChars 127
#define SLcScript_MaxNameLength (32)

typedef struct OBJtOSD_TriggerVolume
{
	char name[OBJcMaxNameLength];
	char entry_script[SLcScript_MaxNameLength];
	char inside_script[SLcScript_MaxNameLength];
	char exit_script[SLcScript_MaxNameLength];

	// TODO: +1 in orig, why do we have to shift here?
	char note[OBJcMaxNoteChars + 2];

	M3tPoint3D scale;
	int32_t id;
	int32_t parent_id;

	M3tBoundingVolume volume;
	M3tBoundingSphere sphere;// not written to disk
	uint32_t team_mask;

	uint32_t authored_flags;
	uint32_t in_game_flags;// not written to disk
	char cur_entry_script[SLcScript_MaxNameLength];// not written to disk
	char cur_inside_script[SLcScript_MaxNameLength];// not written to disk
	char cur_exit_script[SLcScript_MaxNameLength];// not written to disk
} OBJtOSD_TriggerVolume;

typedef struct OBJtOSD_All
{
	union
	{
		//OBJtOSD_Combat combat_osd;
		//OBJtOSD_Character character_osd;
		//OBJtOSD_PatrolPath patrolpath_osd;
		//OBJtOSD_Flag flag_osd;
		//OBJtOSD_Furniture furniture_osd;
		//OBJtOSD_Particle particle_osd;
		//OBJtOSD_PowerUp powerup_osd;
		//OBJtOSD_Sound sound_osd;
		OBJtOSD_TriggerVolume trigger_volume_osd;
		//OBJtOSD_Weapon weapon_osd;
		//OBJtOSD_Trigger trigger_osd;
		//OBJtOSD_Turret turret_osd;
		//OBJtOSD_Console console_osd;
		//OBJtOSD_Door door_osd;
		//OBJtOSD_Melee melee_osd;
		//OBJtOSD_Neutral neutral_osd;
	} osd;
} OBJtOSD_All;

#endif
