#include <windows.h>
#include <string.h>

#include "Daodan_Cheater.h"
#include "Daodan_Config.h"
#include "Daodan_Patch.h"
#include "Daodan_Utility.h"

#include "Oni/Oni.h"

#include "Inifile_Reader.h"

#define ARRAY_SIZE(arr) (sizeof(arr) / sizeof(arr[0]))

static const char* iniName = "daodan.ini";

ConfigSection_t config[] = {
	{ "patches", "Patches", {
		{ "alttab",
			"Allows user to switch applications while in Oni (Alt-Tab) and use Windows key, however it may enable the screensaver as well.",
			C_BOOL,
			{.intBoolVal = true},
			{.intBoolVal = true} },
		{ "argb8888",
			"Textures using ARGB8888 can be used.",
			C_BOOL,
			{.intBoolVal = true},
			{.intBoolVal = true} },
		{ "binkplay",
			"Fix binkplay calls to use GDI and outro same mode as intro.",
			C_BOOL,
			{.intBoolVal = true},
			{.intBoolVal = true} },
		{ "bsl",
			"Enables d_regen (unfinished) and prevents fly-in portraits from being stretched when playing in widescreen resolutions.",
			C_BOOL,
			{.intBoolVal = true},
			{.intBoolVal = true} },
		{ "cheater",
			"Adds new cheat codes (see section below).",
			C_BOOL,
			{.intBoolVal = true},
			{.intBoolVal = true} },
		{ "cheatsenabled",
			"Enables cheats without having to beat the game first.",
			C_BOOL,
			{.intBoolVal = true},
			{.intBoolVal = true} },
		{ "cheattable",
			"Replaces Oni's cheat table with table that includes new cheats (see section below).",
			C_BOOL,
			{.intBoolVal = true},
			{.intBoolVal = true} },
		{ "chinese",
			"Allow for chinese fonts to be shown.",
			C_BOOL,
			{.intBoolVal = true},
			{.intBoolVal = true} },
		{ "clipcursor",
			"Limit cursor to Oni's window.",
			C_BOOL,
			{.intBoolVal = true},
			{.intBoolVal = true} },
		{ "cooldowntimer",
			"Disables weapon cooldown exploit.",
			C_BOOL,
			{.intBoolVal = true},
			{.intBoolVal = true} },
		{ "daodandisplayenum",
			"Offers more display modes in the Options menu.",
			C_BOOL,
			{.intBoolVal = true},
			{.intBoolVal = true} },
		{ "directinput",
			"Forces on DirectInput.",
			C_BOOL,
			{.intBoolVal = true},
			{.intBoolVal = true} },
		{ "disablecmdline",
			"Replaces existing command line parser with Daodan's in order to add new commands. Meant to be used with getcmdline.",
			C_BOOL,
			{.intBoolVal = true},
			{.intBoolVal = true} },
		{ "fonttexturecache",
			"Doubles size of font texture cache.",
			C_BOOL,
			{.intBoolVal = true},
			{.intBoolVal = true} },
		{ "getcmdline",
			"Replaces existing command line parser with Daodan's in order to add new commands. Meant to be used with disablecmdline.",
			C_BOOL,
			{.intBoolVal = true},
			{.intBoolVal = true} },
		{ "hdscreens_lowres",
			"???",
			C_BOOL,
			{.intBoolVal = true},
			{.intBoolVal = true} },
		{ "highres_console",
			"Fixes bug where console line becomes invisible at higher resolutions.",
			C_BOOL,
			{.intBoolVal = true},
			{.intBoolVal = true} },
		{ "kickguns",
			"Unfinished, do not use.",
			C_BOOL,
			{.intBoolVal = false},
			{.intBoolVal = false} },
		{ "largetextures",
			"Textures up to 512x512 can be used.",
			C_BOOL,
			{.intBoolVal = true},
			{.intBoolVal = true} },
		{ "levelplugins",
			"Allows level files to be loaded from the GDF which do not end in \"_Final\".",
			C_BOOL,
			{.intBoolVal = true},
			{.intBoolVal = true} },
		{ "newweap",
			"Picking up a weapon displays a message containing the weapon name and amount of ammo.",
			C_BOOL,
			{.intBoolVal = true},
			{.intBoolVal = true} },
		{ "nomultibyte",
			"Enables languages which use multibyte coding (such as Chinese).",
			C_BOOL,
			{.intBoolVal = true},
			{.intBoolVal = true} },
		{ "optionsvisible",
			"Always show options button in main menu, even when pausing from a game.",
			C_BOOL,
			{.intBoolVal = true},
			{.intBoolVal = true} },
		{ "particledisablebit",
			"Unlocks particle action disabling/enabling bits for all events so that a particle event can occur multiple times.",
			C_BOOL,
			{.intBoolVal = false},
			{.intBoolVal = false} },
		{ "pathfinding",
			"Multiplies size of pathfinding grid cache by eight in order to prevent crashes in large levels.",
			C_BOOL,
			{.intBoolVal = true},
			{.intBoolVal = true} },
		{ "projaware",
			"Allows AI to dodge incoming gunfire properly.",
			C_BOOL,
			{.intBoolVal = true},
			{.intBoolVal = true} },
		{ "safeprintf",
			"Replaces Oni's function that prints to startup.txt with a safer one.",
			C_BOOL,
			{.intBoolVal = true},
			{.intBoolVal = true} },
		{ "showalllasersights",
			"Show all (also enemies') weapon lasersights.",
			C_BOOL,
			{.intBoolVal = false},
			{.intBoolVal = false} },
		{ "showtriggervolumes",
			"Allows BSL variable \"show_triggervolumes\" to work when set to 1.",
			C_BOOL,
			{.intBoolVal = true},
			{.intBoolVal = true} },
		{ "throwtest",
			"Not recommended for use; experiment with allowing enemies to be thrown over railings.",
			C_BOOL,
			{.intBoolVal = false},
			{.intBoolVal = false} },
		{ "usedaodangl",
			"Provides an improved windowed mode (-noswitch); this patch is known to break the hiding of the Windows taskbar in fullscreen mode.",
			C_BOOL,
			{.intBoolVal = true},
			{.intBoolVal = true} },
		{ "usegettickcount",
			"Replaces Oni's timing functions with more accurate ones.",
			C_BOOL,
			{.intBoolVal = true},
			{.intBoolVal = true} },
		{ "wpfadetime",
			"Adds working function for existing BSL command wp_fadetime, sets fade time to 4800.",
			C_BOOL,
			{.intBoolVal = true},
			{.intBoolVal = true} },
		{ 0, 0, 0, {0}, {0} }
	} },
	{ "options", "Options", {
		{ "border",
			"If \"windowhack\" patch is active, make sure game window has border in windowed mode.",
			C_BOOL,
			{.intBoolVal = true},
			{.intBoolVal = true} },
		{ "debug",
			"???",
			EXT_BOOL,
			{.intBoolVal = false },
			{.extBoolVal = &AKgDebug_DebugMaps } },
		{ "debugfiles",
			"???",
			EXT_BOOL,
			{.intBoolVal = false },
			{.extBoolVal = &BFgDebugFileEnable } },
		{ "findsounds",
			"???",
			EXT_BOOL,
			{.intBoolVal = false },
			{.extBoolVal = &SSgSearchOnDisk } },
		{ "gamma",
			"Enable gamma slider in fullscreen.",
			C_BOOL,
			{.intBoolVal = true},
			{.intBoolVal = true} },
		{ "ignore_private_data",
			"???",
			EXT_BOOL,
			{.intBoolVal = false },
			{.extBoolVal = &opt_ignore_private_data } },
		{ "sound",
			"???",
			EXT_BOOL,
			{.intBoolVal = true },
			{.extBoolVal = &opt_sound } },
		{ "switch",
			"Always switch screen to resolution on Oni's Options screen, making the game fullscreen; opposite of Oni's built-in argument \"noswitch\".",
			EXT_BOOL,
			{.intBoolVal = true},
			{.extBoolVal = &M3gResolutionSwitch} },
		{ "topmost",
			"Keep game window on top in windowed mode, even when switching applications.",
			C_BOOL,
			{.intBoolVal = false},
			{.intBoolVal = false} },
		{ "usedaodanbsl",
			"Adds new BSL commands (see below).",
			C_BOOL,
			{.intBoolVal = true},
			{.intBoolVal = true} },
		{ "language",
			"Localization for hardcoded strings (e.g. \"Savepoints\").",
			C_STRING,
			{.stringVal = "en"},
			{.stringVal = "en"} },
		{ 0, 0, 0, {0}, {0} }
	} }
};


void DDrConfig_Print()
{
	for (unsigned int s = 0; s < ARRAY_SIZE(config); s++) {
		for (ConfigOption_t* co = config[s].options; co->name != 0; co++) {
			switch (co->type) {
				case C_STRING:
					STARTUPMESSAGE("Option %s.%s = %s (def %s)", config[s].name, co->name, co->value.stringVal, co->defaultValue.stringVal);
					break;
				case EXT_BOOL:
					STARTUPMESSAGE("Option %s.%s = %d (def %d)", config[s].name, co->name, *co->value.extBoolVal, co->defaultValue.intBoolVal);
					break;
				default:
					STARTUPMESSAGE("Option %s.%s = %d (def %d)", config[s].name, co->name, co->value.intBoolVal, co->defaultValue.intBoolVal);
			}
		}
	}
}

const char* DDrConfig_GetOptionTypeName(OptionType_t type)
{
	switch (type) {
		case C_INT:
			return "Int";
		case C_BOOL:
			return "Bool";
		case C_STRING:
			return "String";
		case EXT_BOOL:
			return "pBool";
		default:
			return "unknown";
	}
}

static ConfigOption_t* DDrConfig_GetOption(const char* fullOptName)
{
	char section[50];
	strcpy(section, fullOptName);

	char* option = strchr(section, '.');
	if (option == 0) {
		STARTUPMESSAGE("Could not find option separator in \"%s\"", fullOptName);
		return 0;
	}
	*option++ = 0;

	for (unsigned int s = 0; s < ARRAY_SIZE(config); s++) {
		if (!_stricmp(config[s].name, section)) {
			for (ConfigOption_t* co = config[s].options; co->name != 0; co++) {
				if (!_stricmp(co->name, option)) {
					return co;
				}
			}
			STARTUPMESSAGE("Could not find option \"%s\" in section \"%s\"", option, section);
			return 0;
		}
	}
	STARTUPMESSAGE("Could not find section \"%s\" for option \"%s\"", section, option);
	return 0;
}



ConfigOption_t* DDrConfig_GetOptOfType(const char* fullOptName, OptionType_t type)
{
	ConfigOption_t* co = DDrConfig_GetOption(fullOptName);
	if (co == 0)
		return 0;

	if (co->type != type) {
		STARTUPMESSAGE("Option \"%s\" is not of type %s", fullOptName, DDrConfig_GetOptionTypeName(type));
		return 0;
	}
	return co;
}


void DDrConfig_InitExtBools()
{
	for (unsigned int s = 0; s < ARRAY_SIZE(config); s++) {
		for (ConfigOption_t* co = config[s].options; co->name != 0; co++) {
			if (co->type == EXT_BOOL) {
				*co->value.extBoolVal = co->defaultValue.intBoolVal;
			}
		}
	}
}



void DDrIniCallback(char* section, char* name, char* value)
{
	static char curSection[20];
	char fullOptName[50];

	if (!_stricmp(section, "patch"))
		section = "patches";

	strcpy(curSection, section);

	strcpy(fullOptName, curSection);
	fullOptName[strlen(curSection)] = '.';
	strcpy(fullOptName+strlen(curSection)+1, name);

	ConfigOption_t* co = DDrConfig_GetOption(fullOptName);

	if (co)
	{
		switch (co->type) {
			case C_INT:
				co->value.intBoolVal = strtol(value, NULL, 0);
				break;
			case C_BOOL:
				co->value.intBoolVal = !_stricmp(value, "true");
				break;
			case C_STRING:
				co->value.stringVal = value;
				break;
			case EXT_BOOL:
				*(co->value.extBoolVal) = !_stricmp(value, "true");
				break;
			default:
				STARTUPMESSAGE("Config value type unknown: %d", co->type);
		}
	}
}

void DDrConfig_WriteTemplateIni()
{
	FILE* fp;
	STARTUPMESSAGE("%s doesn't exist, creating", iniName);
	fp = fopen(iniName, "w");
	if (fp)
	{
		for (unsigned int s = 0; s < ARRAY_SIZE(config); s++) {
			fprintf(fp, "[%s]\n", config[s].name);
		}
		fclose(fp);
	}
}


void DDrConfig(int argc, char* argv[])
{
	int i;
	char* section;
	char* option;
	bool falseoption;

	DDrConfig_InitExtBools();

	if (GetFileAttributes(iniName) == INVALID_FILE_ATTRIBUTES)
		DDrConfig_WriteTemplateIni();
	
	STARTUPMESSAGE("Parsing daodan.ini...", 0);
	if (!Inifile_Read(iniName, DDrIniCallback))
		STARTUPMESSAGE("Error reading daodan.ini, check your syntax!", 0);
	STARTUPMESSAGE("Finished parsing", 0);



	STARTUPMESSAGE("Parsing command line...", 0);
	for (i = 1; i < argc; i ++)
	{
		if (argv[i][0] == '-')
		{
			section = argv[i] + 1;
			if ((option = strchr(argv[i], '.')))
			{
				*option = '\0';
				falseoption = (option[1] == 'n' || option[1] == 'N') && (option[2] == 'o' || option[2] == 'O');
				if (i < (argc - 1) && argv[i + 1][0] != '-')
					DDrIniCallback(section, option + 1, argv[++i]);
				else
					DDrIniCallback(section, option + (falseoption ? 3 : 1), (falseoption ? "false" : "true"));
				*option = '.';
			}
			else
			{
				falseoption = (section[0] == 'n' || section[0] == 'N') && (section[1] == 'o' || section[1] == 'O');
				if (i < (argc - 1) && argv[i + 1][0] != '-')
					DDrIniCallback("options", section, argv[++i]);
				else
					DDrIniCallback("options", section + (falseoption ? 2 : 0), (falseoption ? "false" : "true"));
			}
		}
		else
		{
			STARTUPMESSAGE("Parse error \"%s\"", argv[i]);
			break;
		}
	}
	STARTUPMESSAGE("Finished parsing", 0);
}


/*
		case s_language:
			else if (!_stricmp(name, "blam"))
				DDrPatch__strdup((int*)(OniExe + 0x0010fb73), value);
			else if (!_stricmp(name, "damn"))
				DDrPatch__strdup((int*)(OniExe + 0x0010fb6e), value);
			else if (!_stricmp(name, "savepoint"))
			{
				char* str = _strdup(value);
				DDrPatch_Int32((int*)(OniExe + 0x000fd730), (int)str);
				DDrPatch_Int32((int*)(OniExe + 0x000fd738), (int)str);
			}
			else if (!_stricmp(name, "syndicatewarehouse"))
			{
				char* str = _strdup(value);
				DDrPatch_Int32((int*)(OniExe + 0x000fd71a), (int)str);
				DDrPatch_Int32((int*)(OniExe + 0x0010ef75), (int)str);
			}
			else if (!_stricmp(name, "shapeshifter_on"))
				DDr_CheatTable[0].message_on = _strdup(value);
			else if (!_stricmp(name, "shapeshifter_off"))
				DDr_CheatTable[0].message_off = _strdup(value);
			else if (!_stricmp(name, "liveforever_on"))
				DDr_CheatTable[1].message_on = _strdup(value);
			else if (!_stricmp(name, "liveforever_off"))
				DDr_CheatTable[1].message_off = _strdup(value);
			else if (!_stricmp(name, "touchofdeath_on"))
				DDr_CheatTable[2].message_on = _strdup(value);
			else if (!_stricmp(name, "touchofdeath_off"))
				DDr_CheatTable[2].message_off = _strdup(value);
			else if (!_stricmp(name, "canttouchthis_on"))
				DDr_CheatTable[3].message_on = _strdup(value);
			else if (!_stricmp(name, "canttouchthis_off"))
				DDr_CheatTable[3].message_off = _strdup(value);
			else if (!_stricmp(name, "fatloot_on"))
				DDr_CheatTable[4].message_on = _strdup(value);
			else if (!_stricmp(name, "glassworld_on"))
				DDr_CheatTable[5].message_on = _strdup(value);
			else if (!_stricmp(name, "glassworld_off"))
				DDr_CheatTable[5].message_off = _strdup(value);
			else if (!_stricmp(name, "winlevel_on"))
				DDr_CheatTable[6].message_on = _strdup(value);
			else if (!_stricmp(name, "loselevel_on"))
				DDr_CheatTable[7].message_on = _strdup(value);
			else if (!_stricmp(name, "bighead_on"))
				DDr_CheatTable[8].message_on = _strdup(value);
			else if (!_stricmp(name, "bighead_off"))
				DDr_CheatTable[8].message_off = _strdup(value);
			else if (!_stricmp(name, "minime_on"))
				DDr_CheatTable[9].message_on = _strdup(value);
			else if (!_stricmp(name, "minime_off"))
				DDr_CheatTable[9].message_off = _strdup(value);
			else if (!_stricmp(name, "superammo_on"))
				DDr_CheatTable[10].message_on = _strdup(value);
			else if (!_stricmp(name, "superammo_off"))
				DDr_CheatTable[10].message_off = _strdup(value);
			else if (!_stricmp(name, "devmode_on"))
			{
				char* str = _strdup(value);
				DDr_CheatTable[11].message_on = str;
				DDr_CheatTable[cheat_x].message_on = str;
			}
			else if (!_stricmp(name, "devmode_off"))
			{
				char* str = _strdup(value);
				DDr_CheatTable[11].message_off = str;
				DDr_CheatTable[cheat_x].message_off = str;
			}
			else if (!_stricmp(name, "reservoirdogs_on"))
				DDr_CheatTable[12].message_on = _strdup(value);
			else if (!_stricmp(name, "reservoirdogs_off"))
				DDr_CheatTable[12].message_off = _strdup(value);
			else if (!_stricmp(name, "roughjustice_on"))
				DDr_CheatTable[13].message_on = _strdup(value);
			else if (!_stricmp(name, "roughjustice_off"))
				DDr_CheatTable[13].message_off = _strdup(value);
			else if (!_stricmp(name, "chenille_on"))
				DDr_CheatTable[14].message_on = _strdup(value);
			else if (!_stricmp(name, "chenille_off"))
				DDr_CheatTable[14].message_off = _strdup(value);
			else if (!_stricmp(name, "behemoth_on"))
				DDr_CheatTable[15].message_on = _strdup(value);
			else if (!_stricmp(name, "behemoth_off"))
				DDr_CheatTable[15].message_off = _strdup(value);
			else if (!_stricmp(name, "elderrune_on"))
				DDr_CheatTable[16].message_on = _strdup(value);
			else if (!_stricmp(name, "elderrune_off"))
				DDr_CheatTable[16].message_off = _strdup(value);
			else if (!_stricmp(name, "moonshadow_on"))
				DDr_CheatTable[17].message_on = _strdup(value);
			else if (!_stricmp(name, "moonshadow_off"))
				DDr_CheatTable[17].message_off = _strdup(value);
			else if (!_stricmp(name, "munitionfrenzy_on"))
				DDr_CheatTable[18].message_on = _strdup(value);
			else if (!_stricmp(name, "fistsoflegend_on"))
				DDr_CheatTable[19].message_on = _strdup(value);
			else if (!_stricmp(name, "fistsoflegend_off"))
				DDr_CheatTable[19].message_off = _strdup(value);
			else if (!_stricmp(name, "killmequick_on"))
				DDr_CheatTable[20].message_on = _strdup(value);
			else if (!_stricmp(name, "killmequick_off"))
				DDr_CheatTable[20].message_off = _strdup(value);
			else if (!_stricmp(name, "carousel_on"))
				DDr_CheatTable[21].message_on = _strdup(value);
			else if (!_stricmp(name, "carousel_off"))
				DDr_CheatTable[21].message_off = _strdup(value);
*/	

