#ifndef DAODAN_CONFIG_H
#define DAODAN_CONFIG_H

#include "stdint.h"

typedef enum {
	C_BOOL,
	C_INT,
	C_STRING,
	EXT_BOOL
} OptionType_t;

typedef union {
	int intBoolVal;
	uint8_t* extBoolVal;
	char* stringVal;
} OptionValue_t;

typedef struct {
	char* name;
	char* description;
	OptionType_t type;
	OptionValue_t defaultValue;
	OptionValue_t value;
} ConfigOption_t;

typedef struct {
	char* name;
	char* description;
	ConfigOption_t options[50];
} ConfigSection_t;


void DDrConfig(int argc, char* argv[]);

ConfigOption_t* DDrConfig_GetOptOfType(const char* fullOptName, OptionType_t type);
const char* DDrConfig_GetOptionTypeName(OptionType_t type);

#endif
