#include "soundwizard.h"

SoundWizard::SoundWizard(QString AppDir, QString workspaceWizardLocation, Logger *myLogger, QHash<QString, QString> *commandMap)
{
    this->appLocation=AppDir;
    this->workspaceWizardLocation=workspaceWizardLocation;
    this->myLogger=myLogger;
    this->soundsLocation=this->workspaceWizardLocation+"/Sounds";
    this->commandMap=commandMap;
}

int SoundWizard::exec(){
    this->myWizard = new QWizard();

    QPushButton *restartButton = new QPushButton("Restart");
    this->myWizard->setButton(QWizard::CustomButton1,restartButton);
    this->myWizard->setOption(QWizard::HaveCustomButton1, true);

    connect(this->myWizard, SIGNAL(currentIdChanged(int)), this, SLOT(pageChanged(int)));
    connect(restartButton, SIGNAL(clicked(bool)), this, SLOT(restartWizard()));

    this->myWizard->setWindowIcon(QIcon(":/new/icons/sound.png"));

    //Center and resize QWizard (http://www.thedazzlersinc.com/source/2012/06/04/qt-center-window-in-screen/)
#ifdef Q_OS_WIN
    this->myWizard->resize(640,480);
#else
    this->myWizard->resize(800,600); // Mac OS pcs should be able to render this resolution without any problem. It's also better
    // because the components on mac use more space
#endif
    QRect position = this->myWizard->frameGeometry();
    position.moveCenter(QDesktopWidget().availableGeometry().center());
    this->myWizard->move(position.topLeft());
    //

    SoundPage2 *page2 = new SoundPage2(this->appLocation);
    SoundPage3 *page3 = new SoundPage3();
    SoundPage4 *page4 = new SoundPage4();
    SoundPageFinal *pageFinal = new SoundPageFinal(this->appLocation, this->soundsLocation,page2->soundTable,this->myLogger, this->commandMap);

    this->myWizard->addPage(createIntroPage());
    this->myWizard->addPage(page2);
    this->myWizard->addPage(page3);
    this->myWizard->addPage(page4);
    this->myWizard->addPage(pageFinal);

    this->myWizard->setWindowTitle("Sound wizard");

    //If wizard finished with sucess
    if(this->myWizard->exec()){ //modal and wait for finalization
        //createPackage(this->myWizard, page4);
    }

    delete this->myWizard; // not needed anymore

    return 0;
}

QWizardPage* SoundWizard::createIntroPage() {
    QWizardPage *page = new QWizardPage;
    page->setTitle("Introduction");

    QLabel *label = new QLabel("Welcome to the Oni Sound wizard.\n"
                               "This wizard will allow you to convert in a few and simple steps sounds to oni format.");
    label->setWordWrap(true);

    QVBoxLayout *layout = new QVBoxLayout;
    layout->addWidget(label);
    page->setLayout(layout);

    return page;
}

void SoundWizard::restartWizard(){
    this->myWizard->restart();
}

void SoundWizard::pageChanged(int pageId){
    // Last page?
    if(pageId==4){
        this->myWizard->setOption(QWizard::HaveCustomButton1, true); // set visible
        this->myWizard->button(QWizard::BackButton)->setEnabled(false); // disable back button, use restart if needed
        return;
    }
    this->myWizard->setOption(QWizard::HaveCustomButton1, false); // set invisible
    this->myWizard->button(QWizard::BackButton)->setEnabled(true); // set enable back button
}
